/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.CryptoException;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.ExtendedDigest;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.RuntimeCryptoException;
import org.spongycastle.crypto.StreamCipher;
import org.spongycastle.crypto.agreement.srp.SRP6Client;
import org.spongycastle.crypto.agreement.srp.SRP6Server;
import org.spongycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.spongycastle.crypto.digests.MD5Digest;
import org.spongycastle.crypto.digests.NullDigest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.encodings.PKCS1Encoding;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.ARIAEngine;
import org.spongycastle.crypto.engines.CamelliaEngine;
import org.spongycastle.crypto.engines.DESedeEngine;
import org.spongycastle.crypto.engines.RC4Engine;
import org.spongycastle.crypto.engines.RSABlindedEngine;
import org.spongycastle.crypto.engines.SEEDEngine;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.crypto.modes.AEADBlockCipher;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.modes.CCMBlockCipher;
import org.spongycastle.crypto.modes.GCMBlockCipher;
import org.spongycastle.crypto.modes.OCBBlockCipher;
import org.spongycastle.crypto.params.AEADParameters;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.crypto.params.SRP6GroupParameters;
import org.spongycastle.crypto.prng.DigestRandomGenerator;
import org.spongycastle.tls.HashAlgorithm;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCertificate;
import org.spongycastle.tls.crypto.TlsCipher;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.TlsDHConfig;
import org.spongycastle.tls.crypto.TlsDHDomain;
import org.spongycastle.tls.crypto.TlsECConfig;
import org.spongycastle.tls.crypto.TlsECDomain;
import org.spongycastle.tls.crypto.TlsHMAC;
import org.spongycastle.tls.crypto.TlsHash;
import org.spongycastle.tls.crypto.TlsNonceGenerator;
import org.spongycastle.tls.crypto.TlsSRP6Client;
import org.spongycastle.tls.crypto.TlsSRP6Server;
import org.spongycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.spongycastle.tls.crypto.TlsSRPConfig;
import org.spongycastle.tls.crypto.TlsSecret;
import org.spongycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.spongycastle.tls.crypto.impl.TlsAEADCipher;
import org.spongycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.spongycastle.tls.crypto.impl.TlsBlockCipher;
import org.spongycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.spongycastle.tls.crypto.impl.TlsEncryptor;
import org.spongycastle.tls.crypto.impl.TlsNullCipher;
import org.spongycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.spongycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.spongycastle.tls.crypto.impl.bc.BcTlsECDomain;
import org.spongycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.spongycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom entropySource) {
        this.entropySource = entropySource;
    }

    BcTlsSecret adoptLocalSecret(byte[] data) {
        return new BcTlsSecret(this, data);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(cryptoParams, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(cryptoParams, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 103: {
                return this.createCipher_AES_OCB(cryptoParams, 16, 12);
            }
            case 9: {
                return this.createAESCipher(cryptoParams, 32, macAlgorithm);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 104: {
                return this.createCipher_AES_OCB(cryptoParams, 32, 12);
            }
            case 22: {
                return this.createARIACipher(cryptoParams, 16, macAlgorithm);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
            }
            case 23: {
                return this.createARIACipher(cryptoParams, 32, macAlgorithm);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(cryptoParams, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new BcTlsECDomain(this, ecConfig);
    }

    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificate bcCert = BcTlsCertificate.convert(this, certificate);
        bcCert.validateKeyUsage(32);
        final RSAKeyParameters pubKeyRSA = bcCert.getPubKeyRSA();
        return new TlsEncryptor(){

            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                    encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubKeyRSA, BcTlsCrypto.this.getSecureRandom()));
                    return encoding.processBlock(input, inOff, length);
                }
                catch (InvalidCipherTextException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        final DigestRandomGenerator nonceGen = new DigestRandomGenerator(this.createDigest((short)4));
        if (additionalSeedMaterial != null && additionalSeedMaterial.length > 0) {
            nonceGen.addSeedMaterial(additionalSeedMaterial);
        }
        byte[] seed = new byte[this.createDigest((short)4).getDigestSize()];
        this.entropySource.nextBytes(seed);
        nonceGen.addSeedMaterial(seed);
        return new TlsNonceGenerator(){

            public byte[] generateNonce(int size) {
                byte[] nonce = new byte[size];
                nonceGen.nextBytes(nonce);
                return nonce;
            }
        };
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return true;
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    public boolean hasRSAEncryption() {
        return true;
    }

    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.entropySource.nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    public Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 0: {
                return new NullDigest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    public TlsHash createHash(short algorithm) {
        return new BcTlsHash(algorithm, this.createDigest(algorithm));
    }

    public static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createAESBlockCipher(), true), new BlockOperator(this.createAESBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createARIACipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createARIABlockCipher(), true), new BlockOperator(this.createARIABlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createCamelliaBlockCipher(), true), new BlockOperator(this.createCamelliaBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new TlsAEADCipher(cryptoParams, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_CCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_CCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_GCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_OCB(), true), new AeadOperator(this.createAEADBlockCipher_AES_OCB(), false), cipherKeySize, macSize, 2);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), true), new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), true), new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createDESedeBlockCipher(), true), new BlockOperator(this.createDESedeBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm));
    }

    protected TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createSEEDBlockCipher(), true), new BlockOperator(this.createSEEDBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected BlockCipher createARIABlockCipher() {
        return new CBCBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_OCB() {
        return new OCBBlockCipher(this.createAESEngine(), this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return new GCMBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new SEEDEngine());
    }

    public TlsHMAC createHMAC(int macAlgorithm) {
        return new HMacOperator(this.createDigest(TlsUtils.getHashAlgorithmForHMACAlgorithm(macAlgorithm)));
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpClient.init(srpGroup, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Client(){

            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Server(){

            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], (Digest)new SHA1Digest());
        return new TlsSRP6VerifierGenerator(){

            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.hmac.init((CipherParameters)new KeyParameter(key, keyOff, keyLen));
        }

        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        public void reset() {
            this.hmac.reset();
        }
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean isEncrypting;
        private final AEADBlockCipher cipher;
        private KeyParameter key;

        public AeadOperator(AEADBlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
        }

        public void init(byte[] nonce, int macSize, byte[] additionalData) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, macSize * 8, nonce, additionalData));
        }

        public int getOutputSize(int inputLength) {
            return this.cipher.getOutputSize(inputLength);
        }

        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            try {
                return len + this.cipher.doFinal(output, outputOffset + len);
            }
            catch (InvalidCipherTextException e) {
                throw new RuntimeCryptoException(e.toString());
            }
        }
    }

    private class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, new byte[this.cipher.getBlockSize()]));
        }

        public void init(byte[] iv, int ivOff, int ivLen) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, iv, ivOff, ivLen));
        }

        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int blockSize = this.cipher.getBlockSize();
            for (int i = 0; i < inputLength; i += blockSize) {
                this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            }
            return inputLength;
        }

        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }
    }

    private static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short hashAlgorithm, Digest digest) {
            this.hashAlgorithm = hashAlgorithm;
            this.digest = digest;
        }

        public void update(byte[] data, int offSet, int length) {
            this.digest.update(data, offSet, length);
        }

        public byte[] calculateHash() {
            byte[] rv = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(rv, 0);
            return rv;
        }

        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCrypto.cloneDigest(this.hashAlgorithm, this.digest));
        }

        public void reset() {
            this.digest.reset();
        }
    }
}

