/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.CryptoException;
import org.spongycastle.crypto.DSA;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.signers.DSADigestSigner;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.spongycastle.tls.crypto.impl.bc.BcTlsSigner;

public abstract class BcTlsDSSSigner
extends BcTlsSigner {
    protected BcTlsDSSSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        super(crypto, privateKey);
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        DSADigestSigner s = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), this.crypto.createDigest((short)0));
        s.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        DSADigestSigner signer = s;
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

