/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DSA;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.signers.DSADigestSigner;
import org.spongycastle.tls.DigitallySigned;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.spongycastle.tls.crypto.impl.bc.BcTlsVerifier;

public abstract class BcTlsDSSVerifier
extends BcTlsVerifier {
    protected BcTlsDSSVerifier(BcTlsCrypto crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), this.crypto.createDigest((short)0));
        signer.init(false, (CipherParameters)this.publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(signedParams.getSignature());
    }
}

