/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.asn1.x9.ECNamedCurveTable;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.agreement.ECDHBasicAgreement;
import org.spongycastle.crypto.ec.CustomNamedCurves;
import org.spongycastle.crypto.generators.ECKeyPairGenerator;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyGenerationParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.crypto.TlsAgreement;
import org.spongycastle.tls.crypto.TlsECConfig;
import org.spongycastle.tls.crypto.TlsECDomain;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.spongycastle.tls.crypto.impl.bc.BcTlsECDH;
import org.spongycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.spongycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECDomainParameters ecDomainParameters;

    public static byte[] calculateBasicAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init((CipherParameters)privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement((CipherParameters)publicKey);
        return BigIntegers.asUnsignedByteArray((int)basicAgreement.getFieldSize(), (BigInteger)agreementValue);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig ecConfig) {
        return BcTlsECDomain.getDomainParameters(ecConfig.getNamedGroup());
    }

    public static ECDomainParameters getDomainParameters(int namedGroup) {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return null;
        }
        String curveName = NamedGroup.getName(namedGroup);
        if (curveName == null) {
            return null;
        }
        X9ECParameters ecP = CustomNamedCurves.getByName((String)curveName);
        if (ecP == null && (ecP = ECNamedCurveTable.getByName((String)curveName)) == null) {
            return null;
        }
        return new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.ecConfig = ecConfig;
        this.ecDomainParameters = BcTlsECDomain.getDomainParameters(ecConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        return this.crypto.adoptLocalSecret(BcTlsECDomain.calculateBasicAgreement(privateKey, publicKey));
    }

    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecDomainParameters.getCurve().decodePoint(encoding);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint point = this.decodePoint(encoding);
            return new ECPublicKeyParameters(point, this.ecDomainParameters);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKeyParameters publicKey) throws IOException {
        return this.encodePoint(publicKey.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.ecDomainParameters, this.crypto.getSecureRandom()));
        return keyPairGenerator.generateKeyPair();
    }
}

