/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.jcajce;

import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.jcajce.util.NamedJcaJceHelper;
import org.spongycastle.jcajce.util.ProviderJcaJceHelper;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsCryptoProvider;
import org.spongycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsCryptoProvider
implements TlsCryptoProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaTlsCryptoProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaTlsCryptoProvider setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public TlsCrypto create(SecureRandom random) {
        try {
            if (random == null) {
                SecureRandom keyRandom = this.helper instanceof DefaultJcaJceHelper ? SecureRandom.getInstance("DEFAULT") : SecureRandom.getInstance("DEFAULT", this.helper.createDigest("SHA-512").getProvider());
                return this.create(keyRandom, new NonceEntropySource(this.helper, keyRandom));
            }
            return this.create(random, new NonceEntropySource(this.helper, random));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to create TlsCrypto: " + e.getMessage(), e);
        }
    }

    public TlsCrypto create(SecureRandom keyRandom, SecureRandom nonceRandom) {
        return new JcaTlsCrypto(this.helper, keyRandom, nonceRandom);
    }

    public Provider getPkixProvider() {
        try {
            if (Security.getProvider("IBMCertPath") != null) {
                return Security.getProvider("IBMCertPath");
            }
            return this.helper.createCertificateFactory("X.509").getProvider();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to find CertificateFactory");
        }
    }

    private static class NonceEntropySource
    extends SecureRandom {
        NonceEntropySource(JcaJceHelper helper, SecureRandom random) throws GeneralSecurityException {
            super(new NonceEntropySourceSpi(random, helper.createDigest("SHA-512")), random.getProvider());
        }

        private static class NonceEntropySourceSpi
        extends SecureRandomSpi {
            private final SecureRandom source;
            private final MessageDigest digest;
            private final byte[] seed;
            private final byte[] state;

            public NonceEntropySourceSpi(SecureRandom source, MessageDigest digest) {
                this.source = source;
                this.digest = digest;
                this.seed = source.generateSeed(digest.getDigestLength());
                this.state = new byte[this.seed.length];
            }

            protected void engineSetSeed(byte[] bytes) {
                this.digest.update(this.seed, 0, this.seed.length);
                this.digest.update(bytes, 0, bytes.length);
                try {
                    this.digest.digest(this.seed, 0, this.seed.length);
                }
                catch (DigestException e) {
                    throw new IllegalStateException("unable to generate nonce data: " + e.getMessage(), e);
                }
            }

            protected void engineNextBytes(byte[] bytes) {
                int stateOff = 0;
                this.generateState();
                for (int i = 0; i != bytes.length; ++i) {
                    if (stateOff == this.state.length) {
                        this.generateState();
                        stateOff = 0;
                    }
                    bytes[i] = this.state[stateOff++];
                }
            }

            protected byte[] engineGenerateSeed(int seedLen) {
                return this.source.generateSeed(seedLen);
            }

            private void generateState() {
                this.source.nextBytes(this.state);
                this.digest.update(this.seed);
                this.digest.update(this.state);
                try {
                    this.digest.digest(this.state, 0, this.state.length);
                }
                catch (DigestException e) {
                    throw new IllegalStateException("unable to generate nonce data: " + e.getMessage(), e);
                }
            }
        }
    }
}

