/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.DigestInfo;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.tls.DigitallySigned;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsStreamVerifier;
import org.spongycastle.tls.crypto.TlsVerifier;
import org.spongycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.spongycastle.tls.crypto.impl.jcajce.SignatureOutputStream;

public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    protected RSAPublicKey pubKeyRSA;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(RSAPublicKey pubKeyRSA, JcaJceHelper helper) {
        if (pubKeyRSA == null) {
            throw new IllegalArgumentException("'pubKeyRSA' cannot be null");
        }
        this.pubKeyRSA = pubKeyRSA;
        this.helper = helper;
    }

    public TlsStreamVerifier getStreamVerifier(final DigitallySigned signature) throws IOException {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive()) {
            try {
                Signature rawVerifier = this.getRawVerifier();
                if (JcaUtils.isSunMSCAPIProvider(rawVerifier.getProvider())) {
                    String algorithmName = JcaUtils.getJcaAlgorithmName(algorithm);
                    final Signature verifier = this.helper.createSignature(algorithmName);
                    verifier.initVerify(this.pubKeyRSA);
                    return new TlsStreamVerifier(){

                        public OutputStream getOutputStream() {
                            return new SignatureOutputStream(verifier);
                        }

                        public boolean isVerified() throws IOException {
                            try {
                                return verifier.verify(signature.getSignature());
                            }
                            catch (SignatureException e) {
                                throw new TlsFatalAlert(80, (Throwable)e);
                            }
                        }
                    };
                }
            }
            catch (GeneralSecurityException e) {
                throw new TlsFatalAlert(80, (Throwable)e);
            }
        }
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws IOException {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        try {
            Signature verifier = this.getRawVerifier();
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                AlgorithmIdentifier algID = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE);
                byte[] digestInfo = new DigestInfo(algID, hash).getEncoded();
                verifier.update(digestInfo, 0, digestInfo.length);
            } else {
                verifier.update(hash, 0, hash.length);
            }
            return verifier.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.helper.createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.pubKeyRSA);
        }
        return this.rawVerifier;
    }
}

