/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.spongycastle.util.Arrays;

public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private final Cipher cipher;
    private final String algorithm;
    private final boolean isEncrypting;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.isEncrypting = isEncrypting;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    public void init(byte[] iv, int ivOff, int ivLen) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = Arrays.copyOfRange((byte[])iv, (int)ivOff, (int)(ivOff + ivLen));
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            this.cipher.init(this.isEncrypting ? 1 : 2, (Key)this.key, new IvParameterSpec(this.nextIV));
            this.nextIV = null;
            if (!this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])input, (int)(inputOffset + inputLength - this.cipher.getBlockSize()), (int)(inputOffset + inputLength));
            }
            int len = this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
            if (this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])output, (int)(outputOffset + inputLength - this.cipher.getBlockSize()), (int)(outputOffset + inputLength));
            }
            return len;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

