/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.Pack;

public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper helper, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = helper.createCipher("ChaCha7539");
        this.mac = helper.createMac("Poly1305");
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        try {
            if (this.cipherMode == 1) {
                int ciphertextLength = inputLength;
                byte[] tmp = new byte[64 + ciphertextLength];
                System.arraycopy(input, inputOffset, tmp, 64, ciphertextLength);
                if (tmp.length != this.cipher.doFinal(tmp, 0, tmp.length, tmp, 0)) {
                    throw new IllegalStateException();
                }
                System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
                this.initMAC(tmp);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(tmp, 64, ciphertextLength);
                byte[] lengths = new byte[16];
                Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])lengths, (int)0);
                Pack.longToLittleEndian((long)((long)ciphertextLength & 0xFFFFFFFFL), (byte[])lengths, (int)8);
                this.mac.update(lengths, 0, 16);
                this.mac.doFinal(output, outputOffset + ciphertextLength);
                return ciphertextLength + 16;
            }
            int ciphertextLength = inputLength - 16;
            byte[] tmp = new byte[64 + ciphertextLength];
            System.arraycopy(input, inputOffset, tmp, 64, ciphertextLength);
            if (tmp.length != this.cipher.doFinal(tmp, 0, tmp.length, tmp, 0)) {
                throw new IllegalStateException();
            }
            this.initMAC(tmp);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(input, inputOffset, ciphertextLength);
            byte[] calculatedMAC = new byte[16];
            Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])calculatedMAC, (int)0);
            Pack.longToLittleEndian((long)((long)ciphertextLength & 0xFFFFFFFFL), (byte[])calculatedMAC, (int)8);
            this.mac.update(calculatedMAC, 0, 16);
            this.mac.doFinal(calculatedMAC, 0);
            byte[] receivedMAC = Arrays.copyOfRange((byte[])input, (int)(inputOffset + ciphertextLength), (int)(inputOffset + inputLength));
            if (!Arrays.constantTimeAreEqual((byte[])calculatedMAC, (byte[])receivedMAC)) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(tmp, 64, output, outputOffset, ciphertextLength);
            return ciphertextLength;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOutputSize(int inputLength) {
        return this.cipherMode == 1 ? inputLength + 16 : inputLength - 16;
    }

    public void init(byte[] nonce, int macSize, byte[] additionalData) throws IOException {
        if (nonce == null || nonce.length != 12 || macSize != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(nonce));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        this.additionalData = additionalData;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) throws IOException {
        this.cipherKey = new SecretKeySpec(key, keyOff, keyLen, "ChaCha7539");
    }

    protected void initMAC(byte[] firstBlock) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(firstBlock, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            firstBlock[i] = 0;
        }
    }

    protected void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            this.mac.update(ZEROES, 0, 16 - partial);
        }
    }
}

