/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.ContainedPacket;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.bcpg.PublicKeyAlgorithmTags;
import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.bcpg.SignatureSubpacketInputStream;
import org.spongycastle.bcpg.sig.IssuerKeyID;
import org.spongycastle.bcpg.sig.SignatureCreationTime;
import org.spongycastle.util.Arrays;

public class SignaturePacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private int signatureType;
    private long creationTime;
    private long keyID;
    private int keyAlgorithm;
    private int hashAlgorithm;
    private MPInteger[] signature;
    private byte[] fingerPrint;
    private SignatureSubpacket[] hashedData;
    private SignatureSubpacket[] unhashedData;
    private byte[] signatureEncoding;

    SignaturePacket(BCPGInputStream in) throws IOException {
        this.version = in.read();
        if (this.version == 3 || this.version == 2) {
            int l = in.read();
            this.signatureType = in.read();
            this.creationTime = ((long)in.read() << 24 | (long)(in.read() << 16) | (long)(in.read() << 8) | (long)in.read()) * 1000L;
            this.keyID |= (long)in.read() << 56;
            this.keyID |= (long)in.read() << 48;
            this.keyID |= (long)in.read() << 40;
            this.keyID |= (long)in.read() << 32;
            this.keyID |= (long)in.read() << 24;
            this.keyID |= (long)in.read() << 16;
            this.keyID |= (long)in.read() << 8;
            this.keyID |= (long)in.read();
            this.keyAlgorithm = in.read();
            this.hashAlgorithm = in.read();
        } else if (this.version == 4) {
            SignatureSubpacket sub;
            this.signatureType = in.read();
            this.keyAlgorithm = in.read();
            this.hashAlgorithm = in.read();
            int hashedLength = in.read() << 8 | in.read();
            byte[] hashed = new byte[hashedLength];
            in.readFully(hashed);
            SignatureSubpacketInputStream sIn = new SignatureSubpacketInputStream(new ByteArrayInputStream(hashed));
            Vector<SignatureSubpacket> v = new Vector<SignatureSubpacket>();
            while ((sub = sIn.readPacket()) != null) {
                v.addElement(sub);
            }
            this.hashedData = new SignatureSubpacket[v.size()];
            for (int i = 0; i != this.hashedData.length; ++i) {
                SignatureSubpacket p = (SignatureSubpacket)v.elementAt(i);
                if (p instanceof IssuerKeyID) {
                    this.keyID = ((IssuerKeyID)p).getKeyID();
                } else if (p instanceof SignatureCreationTime) {
                    this.creationTime = ((SignatureCreationTime)p).getTime().getTime();
                }
                this.hashedData[i] = p;
            }
            int unhashedLength = in.read() << 8 | in.read();
            byte[] unhashed = new byte[unhashedLength];
            in.readFully(unhashed);
            sIn = new SignatureSubpacketInputStream(new ByteArrayInputStream(unhashed));
            v.removeAllElements();
            while ((sub = sIn.readPacket()) != null) {
                v.addElement(sub);
            }
            this.unhashedData = new SignatureSubpacket[v.size()];
            for (int i = 0; i != this.unhashedData.length; ++i) {
                SignatureSubpacket p = (SignatureSubpacket)v.elementAt(i);
                if (p instanceof IssuerKeyID) {
                    this.keyID = ((IssuerKeyID)p).getKeyID();
                }
                this.unhashedData[i] = p;
            }
        } else {
            throw new RuntimeException("unsupported version: " + this.version);
        }
        this.fingerPrint = new byte[2];
        in.readFully(this.fingerPrint);
        switch (this.keyAlgorithm) {
            case 1: 
            case 3: {
                MPInteger v = new MPInteger(in);
                this.signature = new MPInteger[1];
                this.signature[0] = v;
                break;
            }
            case 17: {
                MPInteger r = new MPInteger(in);
                MPInteger s = new MPInteger(in);
                this.signature = new MPInteger[2];
                this.signature[0] = r;
                this.signature[1] = s;
                break;
            }
            case 16: 
            case 20: {
                MPInteger p = new MPInteger(in);
                MPInteger g = new MPInteger(in);
                MPInteger y = new MPInteger(in);
                this.signature = new MPInteger[3];
                this.signature[0] = p;
                this.signature[1] = g;
                this.signature[2] = y;
                break;
            }
            case 19: {
                MPInteger ecR = new MPInteger(in);
                MPInteger ecS = new MPInteger(in);
                this.signature = new MPInteger[2];
                this.signature[0] = ecR;
                this.signature[1] = ecS;
                break;
            }
            default: {
                if (this.keyAlgorithm >= 100 && this.keyAlgorithm <= 110) {
                    int ch;
                    this.signature = null;
                    ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                    while ((ch = in.read()) >= 0) {
                        bOut.write(ch);
                    }
                    this.signatureEncoding = bOut.toByteArray();
                    break;
                }
                throw new IOException("unknown signature key algorithm: " + this.keyAlgorithm);
            }
        }
    }

    public SignaturePacket(int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, MPInteger[] signature) {
        this(4, signatureType, keyID, keyAlgorithm, hashAlgorithm, hashedData, unhashedData, fingerPrint, signature);
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, long creationTime, byte[] fingerPrint, MPInteger[] signature) {
        this(version, signatureType, keyID, keyAlgorithm, hashAlgorithm, null, null, fingerPrint, signature);
        this.creationTime = creationTime;
    }

    public SignaturePacket(int version, int signatureType, long keyID, int keyAlgorithm, int hashAlgorithm, SignatureSubpacket[] hashedData, SignatureSubpacket[] unhashedData, byte[] fingerPrint, MPInteger[] signature) {
        this.version = version;
        this.signatureType = signatureType;
        this.keyID = keyID;
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.hashedData = hashedData;
        this.unhashedData = unhashedData;
        this.fingerPrint = fingerPrint;
        this.signature = signature;
        if (hashedData != null) {
            this.setCreationTime();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getSignatureTrailer() {
        byte[] trailer = null;
        if (this.version == 3 || this.version == 2) {
            trailer = new byte[5];
            long time = this.creationTime / 1000L;
            trailer[0] = (byte)this.signatureType;
            trailer[1] = (byte)(time >> 24);
            trailer[2] = (byte)(time >> 16);
            trailer[3] = (byte)(time >> 8);
            trailer[4] = (byte)time;
        } else {
            ByteArrayOutputStream sOut = new ByteArrayOutputStream();
            try {
                sOut.write((byte)this.getVersion());
                sOut.write((byte)this.getSignatureType());
                sOut.write((byte)this.getKeyAlgorithm());
                sOut.write((byte)this.getHashAlgorithm());
                ByteArrayOutputStream hOut = new ByteArrayOutputStream();
                SignatureSubpacket[] hashed = this.getHashedSubPackets();
                for (int i = 0; i != hashed.length; ++i) {
                    hashed[i].encode(hOut);
                }
                byte[] data = hOut.toByteArray();
                sOut.write((byte)(data.length >> 8));
                sOut.write((byte)data.length);
                sOut.write(data);
                byte[] hData = sOut.toByteArray();
                sOut.write((byte)this.getVersion());
                sOut.write(-1);
                sOut.write((byte)(hData.length >> 24));
                sOut.write((byte)(hData.length >> 16));
                sOut.write((byte)(hData.length >> 8));
                sOut.write((byte)hData.length);
            }
            catch (IOException e) {
                throw new RuntimeException("exception generating trailer: " + e);
            }
            trailer = sOut.toByteArray();
        }
        return trailer;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public MPInteger[] getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        if (this.signatureEncoding == null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream bcOut = new BCPGOutputStream(bOut);
            for (int i = 0; i != this.signature.length; ++i) {
                try {
                    bcOut.writeObject(this.signature[i]);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("internal error: " + e);
                }
            }
            return bOut.toByteArray();
        }
        return Arrays.clone((byte[])this.signatureEncoding);
    }

    public SignatureSubpacket[] getHashedSubPackets() {
        return this.hashedData;
    }

    public SignatureSubpacket[] getUnhashedSubPackets() {
        return this.unhashedData;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        if (this.version == 3 || this.version == 2) {
            pOut.write(5);
            long time = this.creationTime / 1000L;
            pOut.write(this.signatureType);
            pOut.write((byte)(time >> 24));
            pOut.write((byte)(time >> 16));
            pOut.write((byte)(time >> 8));
            pOut.write((byte)time);
            pOut.write((byte)(this.keyID >> 56));
            pOut.write((byte)(this.keyID >> 48));
            pOut.write((byte)(this.keyID >> 40));
            pOut.write((byte)(this.keyID >> 32));
            pOut.write((byte)(this.keyID >> 24));
            pOut.write((byte)(this.keyID >> 16));
            pOut.write((byte)(this.keyID >> 8));
            pOut.write((byte)this.keyID);
            pOut.write(this.keyAlgorithm);
            pOut.write(this.hashAlgorithm);
        } else if (this.version == 4) {
            pOut.write(this.signatureType);
            pOut.write(this.keyAlgorithm);
            pOut.write(this.hashAlgorithm);
            ByteArrayOutputStream sOut = new ByteArrayOutputStream();
            for (int i = 0; i != this.hashedData.length; ++i) {
                this.hashedData[i].encode(sOut);
            }
            byte[] data = sOut.toByteArray();
            pOut.write(data.length >> 8);
            pOut.write(data.length);
            pOut.write(data);
            sOut.reset();
            for (int i = 0; i != this.unhashedData.length; ++i) {
                this.unhashedData[i].encode(sOut);
            }
            data = sOut.toByteArray();
            pOut.write(data.length >> 8);
            pOut.write(data.length);
            pOut.write(data);
        } else {
            throw new IOException("unknown version: " + this.version);
        }
        pOut.write(this.fingerPrint);
        if (this.signature != null) {
            for (int i = 0; i != this.signature.length; ++i) {
                pOut.writeObject(this.signature[i]);
            }
        } else {
            pOut.write(this.signatureEncoding);
        }
        out.writePacket(2, bOut.toByteArray(), true);
    }

    private void setCreationTime() {
        for (int i = 0; i != this.hashedData.length; ++i) {
            if (!(this.hashedData[i] instanceof SignatureCreationTime)) continue;
            this.creationTime = ((SignatureCreationTime)this.hashedData[i]).getTime().getTime();
            break;
        }
    }
}

