/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg.attr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.spongycastle.bcpg.UserAttributeSubpacket;

public class ImageAttribute
extends UserAttributeSubpacket {
    public static final int JPEG = 1;
    private static final byte[] ZEROES = new byte[12];
    private int hdrLength;
    private int version;
    private int encoding;
    private byte[] imageData;

    public ImageAttribute(byte[] data) {
        super(1, data);
        this.hdrLength = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.version = data[2] & 0xFF;
        this.encoding = data[3] & 0xFF;
        this.imageData = new byte[data.length - this.hdrLength];
        System.arraycopy(data, this.hdrLength, this.imageData, 0, this.imageData.length);
    }

    public ImageAttribute(int imageType, byte[] imageData) {
        this(ImageAttribute.toByteArray(imageType, imageData));
    }

    private static byte[] toByteArray(int imageType, byte[] imageData) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            bOut.write(16);
            bOut.write(0);
            bOut.write(1);
            bOut.write(imageType);
            bOut.write(ZEROES);
            bOut.write(imageData);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to encode to byte array!");
        }
        return bOut.toByteArray();
    }

    public int version() {
        return this.version;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public byte[] getImageData() {
        return this.imageData;
    }
}

