/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Date;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.DSASecretBCPGKey;
import org.spongycastle.bcpg.ElGamalSecretBCPGKey;
import org.spongycastle.bcpg.RSASecretBCPGKey;
import org.spongycastle.jce.interfaces.ElGamalPrivateKey;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;

public class PGPKeyPair {
    protected PGPPublicKey pub;
    protected PGPPrivateKey priv;

    public PGPKeyPair(int algorithm, KeyPair keyPair, Date time, String provider) throws PGPException, NoSuchProviderException {
        this(algorithm, keyPair.getPublic(), keyPair.getPrivate(), time, provider);
    }

    public PGPKeyPair(int algorithm, KeyPair keyPair, Date time) throws PGPException {
        this(algorithm, keyPair.getPublic(), keyPair.getPrivate(), time);
    }

    public PGPKeyPair(int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String provider) throws PGPException, NoSuchProviderException {
        this(algorithm, pubKey, privKey, time);
    }

    public PGPKeyPair(int algorithm, PublicKey pubKey, PrivateKey privKey, Date time) throws PGPException {
        BCPGObject privPk;
        this.pub = new PGPPublicKey(algorithm, pubKey, time);
        switch (this.pub.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rsK = (RSAPrivateCrtKey)privKey;
                privPk = new RSASecretBCPGKey(rsK.getPrivateExponent(), rsK.getPrimeP(), rsK.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dsK = (DSAPrivateKey)privKey;
                privPk = new DSASecretBCPGKey(dsK.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKey esK = (ElGamalPrivateKey)privKey;
                privPk = new ElGamalSecretBCPGKey(esK.getX());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        this.priv = new PGPPrivateKey(this.pub.getKeyID(), this.pub.getPublicKeyPacket(), (BCPGKey)((Object)privPk));
    }

    public PGPKeyPair(PGPPublicKey pub, PGPPrivateKey priv) {
        this.pub = pub;
        this.priv = priv;
    }

    protected PGPKeyPair() {
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }
}

