/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.Packet;
import org.spongycastle.bcpg.SignaturePacket;
import org.spongycastle.bcpg.TrustPacket;
import org.spongycastle.bcpg.UserAttributePacket;
import org.spongycastle.bcpg.UserIDPacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPUserAttributeSubpacketVector;

public abstract class PGPKeyRing {
    PGPKeyRing() {
    }

    static BCPGInputStream wrap(InputStream in) {
        if (in instanceof BCPGInputStream) {
            return (BCPGInputStream)in;
        }
        return new BCPGInputStream(in);
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream pIn) throws IOException {
        return pIn.nextPacketTag() == 12 ? (TrustPacket)pIn.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream pIn) throws IOException {
        try {
            ArrayList<PGPSignature> sigList = new ArrayList<PGPSignature>();
            while (pIn.nextPacketTag() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)pIn.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(pIn);
                sigList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            return sigList;
        }
        catch (PGPException e) {
            throw new IOException("can't create signature object: " + e.getMessage() + ", cause: " + e.getUnderlyingException().toString());
        }
    }

    static void readUserIDs(BCPGInputStream pIn, List ids, List idTrusts, List idSigs) throws IOException {
        while (pIn.nextPacketTag() == 13 || pIn.nextPacketTag() == 17) {
            Packet obj = pIn.readPacket();
            if (obj instanceof UserIDPacket) {
                UserIDPacket id = (UserIDPacket)obj;
                ids.add(id.getID());
            } else {
                UserAttributePacket user = (UserAttributePacket)obj;
                ids.add(new PGPUserAttributeSubpacketVector(user.getSubpackets()));
            }
            idTrusts.add(PGPKeyRing.readOptionalTrustPacket(pIn));
            idSigs.add(PGPKeyRing.readSignaturesAndTrust(pIn));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;
}

