/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.bcpg.PublicSubkeyPacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKeyPair;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.PGPSecretKey;
import org.spongycastle.openpgp.PGPSecretKeyRing;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureGenerator;
import org.spongycastle.openpgp.PGPSignatureSubpacketVector;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.spongycastle.openpgp.operator.PGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, masterKey, id, encAlgorithm, passPhrase, false, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, masterKey, id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, PGPUtil.getProvider(provider));
    }

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, Provider provider) throws PGPException, NoSuchProviderException {
        this.masterKey = masterKey;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.keyEncryptor = new JcePBESecretKeyEncryptorBuilder(encAlgorithm).setProvider(provider).setSecureRandom(rand).build(passPhrase);
        this.checksumCalculator = PGPKeyRingGenerator.convertSHA1Flag(useSHA1);
        this.keySignerBuilder = new JcaPGPContentSignerBuilder(masterKey.getPublicKey().getAlgorithm(), 2);
        this.keys.add(new PGPSecretKey(certificationLevel, masterKey, id, this.checksumCalculator, hashedPcks, unhashedPcks, this.keySignerBuilder, this.keyEncryptor));
    }

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.masterKey = masterKey;
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.keys.add(new PGPSecretKey(certificationLevel, masterKey, id, checksumCalculator, hashedPcks, unhashedPcks, keySignerBuilder, keyEncryptor));
    }

    public void addSubKey(PGPKeyPair keyPair) throws PGPException {
        this.addSubKey(keyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks) throws PGPException {
        try {
            PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.keySignerBuilder);
            sGen.init(24, this.masterKey.getPrivateKey());
            sGen.setHashedSubpackets(hashedPcks);
            sGen.setUnhashedSubpackets(unhashedPcks);
            ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
            subSigs.add(sGen.generateCertification(this.masterKey.getPublicKey(), keyPair.getPublicKey()));
            this.keys.add(new PGPSecretKey(keyPair.getPrivateKey(), new PGPPublicKey(keyPair.getPublicKey(), null, subSigs), this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception adding subkey: ", e);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator it = this.keys.iterator();
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        while (it.hasNext()) {
            PGPPublicKey k = new PGPPublicKey(((PGPSecretKey)it.next()).getPublicKey());
            k.publicPk = new PublicSubkeyPacket(k.getAlgorithm(), k.getCreationTime(), k.publicPk.getKey());
            pubKeys.add(k);
        }
        return new PGPPublicKeyRing(pubKeys);
    }

    private static PGPDigestCalculator convertSHA1Flag(boolean useSHA1) throws PGPException {
        return useSHA1 ? new JcaPGPDigestCalculatorProviderBuilder().build().get(2) : null;
    }
}

