/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.openpgp.PGPCompressedData;
import org.spongycastle.openpgp.PGPEncryptedDataList;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPLiteralData;
import org.spongycastle.openpgp.PGPMarker;
import org.spongycastle.openpgp.PGPOnePassSignature;
import org.spongycastle.openpgp.PGPOnePassSignatureList;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.PGPSecretKeyRing;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureList;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class PGPObjectFactory {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;

    public PGPObjectFactory(InputStream in) {
        this(in, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
    }

    public PGPObjectFactory(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) {
        this.in = new BCPGInputStream(in);
        this.fingerPrintCalculator = fingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public PGPObjectFactory(byte[] bytes, KeyFingerPrintCalculator fingerPrintCalculator) {
        this(new ByteArrayInputStream(bytes), fingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 2: {
                ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        l.add(new PGPSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create signature object: " + e);
                    }
                }
                return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("can't create secret key object: " + e);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("processing error: " + e.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> l = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        l.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create one pass signature object: " + e);
                    }
                }
                return new PGPOnePassSignatureList(l.toArray(new PGPOnePassSignature[l.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
        }
        throw new IOException("unknown object in stream: " + this.in.nextPacketTag());
    }
}

