/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.DSASecretBCPGKey;
import org.spongycastle.bcpg.ElGamalSecretBCPGKey;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.bcpg.RSASecretBCPGKey;
import org.spongycastle.jce.interfaces.ElGamalPrivateKey;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

public class PGPPrivateKey {
    private long keyID;
    private PrivateKey privateKey;
    private PublicKeyPacket publicKeyPacket;
    private BCPGKey privateKeyDataPacket;

    public PGPPrivateKey(PrivateKey privateKey, long keyID) {
        this.privateKey = privateKey;
        this.keyID = keyID;
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsK = (RSAPrivateCrtKey)privateKey;
            this.privateKeyDataPacket = new RSASecretBCPGKey(rsK.getPrivateExponent(), rsK.getPrimeP(), rsK.getPrimeQ());
        } else if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dsK = (DSAPrivateKey)privateKey;
            this.privateKeyDataPacket = new DSASecretBCPGKey(dsK.getX());
        } else if (privateKey instanceof ElGamalPrivateKey) {
            ElGamalPrivateKey esK = (ElGamalPrivateKey)privateKey;
            this.privateKeyDataPacket = new ElGamalSecretBCPGKey(esK.getX());
        } else {
            throw new IllegalArgumentException("unknown key class");
        }
    }

    public PGPPrivateKey(long keyID, PublicKeyPacket publicKeyPacket, BCPGKey privateKeyDataPacket) {
        this.keyID = keyID;
        this.publicKeyPacket = publicKeyPacket;
        this.privateKeyDataPacket = privateKeyDataPacket;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public PrivateKey getKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        try {
            return new JcaPGPKeyConverter().setProvider(PGPUtil.getDefaultProvider()).getPrivateKey(this);
        }
        catch (PGPException e) {
            throw new IllegalStateException("unable to convert key: " + e.toString());
        }
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicKeyPacket;
    }

    public BCPGKey getPrivateKeyDataPacket() {
        return this.privateKeyDataPacket;
    }
}

