/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.ContainedPacket;
import org.spongycastle.bcpg.DSASecretBCPGKey;
import org.spongycastle.bcpg.ElGamalSecretBCPGKey;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.bcpg.RSASecretBCPGKey;
import org.spongycastle.bcpg.S2K;
import org.spongycastle.bcpg.SecretKeyPacket;
import org.spongycastle.bcpg.SecretSubkeyPacket;
import org.spongycastle.bcpg.UserAttributePacket;
import org.spongycastle.bcpg.UserIDPacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKeyPair;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureGenerator;
import org.spongycastle.openpgp.PGPSignatureSubpacketVector;
import org.spongycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.spongycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.spongycastle.openpgp.operator.PGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class PGPSecretKey {
    SecretKeyPacket secret;
    PGPPublicKey pub;

    PGPSecretKey(SecretKeyPacket secret, PGPPublicKey pub) {
        this.secret = secret;
        this.pub = pub;
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(privKey, pubKey, checksumCalculator, false, keyEncryptor);
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, boolean isMasterKey, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.pub = pubKey;
        BCPGObject secKey = (BCPGObject)((Object)privKey.getPrivateKeyDataPacket());
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pOut = new BCPGOutputStream(bOut);
            pOut.writeObject(secKey);
            byte[] keyData = bOut.toByteArray();
            pOut.write(PGPSecretKey.checksum(checksumCalculator, keyData, keyData.length));
            int encAlgorithm = keyEncryptor.getAlgorithm();
            if (encAlgorithm != 0) {
                int s2kUsage;
                keyData = bOut.toByteArray();
                byte[] encData = keyEncryptor.encryptKeyData(keyData, 0, keyData.length);
                byte[] iv = keyEncryptor.getCipherIV();
                S2K s2k = keyEncryptor.getS2K();
                if (checksumCalculator != null) {
                    if (checksumCalculator.getAlgorithm() != 2) {
                        throw new PGPException("only SHA1 supported for key checksum calculations.");
                    }
                    s2kUsage = 254;
                } else {
                    s2kUsage = 255;
                }
                this.secret = isMasterKey ? new SecretKeyPacket(this.pub.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData) : new SecretSubkeyPacket(this.pub.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData);
            } else {
                this.secret = isMasterKey ? new SecretKeyPacket(this.pub.publicPk, encAlgorithm, null, null, bOut.toByteArray()) : new SecretSubkeyPacket(this.pub.publicPk, encAlgorithm, null, null, bOut.toByteArray());
            }
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception encrypting key", e);
        }
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, keyPair, id, encAlgorithm, passPhrase, false, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, keyPair, id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, PGPUtil.getProvider(provider));
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(certificationLevel, keyPair, id, null, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, Provider provider) throws PGPException {
        this(keyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, new JcaPGPContentSignerBuilder(keyPair.getPublicKey().getAlgorithm(), 2).setProvider(provider)), PGPSecretKey.convertSHA1Flag(useSHA1), true, new JcePBESecretKeyEncryptorBuilder(encAlgorithm, new JcaPGPDigestCalculatorProviderBuilder().build().get(2)).setProvider(provider).setSecureRandom(rand).build(passPhrase));
    }

    private static PGPDigestCalculator convertSHA1Flag(boolean useSHA1) throws PGPException {
        return useSHA1 ? new JcaPGPDigestCalculatorProviderBuilder().build().get(2) : null;
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(keyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, certificationSignerBuilder), checksumCalculator, true, keyEncryptor);
    }

    private static PGPPublicKey certifiedPublicKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder) throws PGPException {
        PGPSignatureGenerator sGen;
        try {
            sGen = new PGPSignatureGenerator(certificationSignerBuilder);
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sGen.init(certificationLevel, keyPair.getPrivateKey());
        sGen.setHashedSubpackets(hashedPcks);
        sGen.setUnhashedSubpackets(unhashedPcks);
        try {
            PGPSignature certification = sGen.generateCertification(id, keyPair.getPublicKey());
            return PGPPublicKey.addCertification(keyPair.getPublicKey(), id, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing certification: " + e, e);
        }
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, int encAlgorithm, char[] passPhrase, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, encAlgorithm, passPhrase, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, int encAlgorithm, char[] passPhrase, boolean useSHA1, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, encAlgorithm, passPhrase, useSHA1, hashedPcks, unhashedPcks, rand, provider);
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, checksumCalculator, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
    }

    public PGPSecretKey(int certificationLevel, int algorithm, PublicKey pubKey, PrivateKey privKey, Date time, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException, NoSuchProviderException {
        this(certificationLevel, new PGPKeyPair(algorithm, pubKey, privKey, time), id, null, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
    }

    public boolean isSigningKey() {
        int algorithm = this.pub.getAlgorithm();
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 20;
    }

    public boolean isMasterKey() {
        return this.pub.isMasterKey();
    }

    public boolean isPrivateKeyEmpty() {
        byte[] secKeyData = this.secret.getSecretKeyData();
        return secKeyData == null || secKeyData.length < 1;
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractKeyData(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        byte[] encData = this.secret.getSecretKeyData();
        byte[] data = null;
        if (this.secret.getEncAlgorithm() == 0) return encData;
        try {
            if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                byte[] key = decryptorFactory.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
                data = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, this.secret.getIV(), encData, 0, encData.length);
                boolean useSHA1 = this.secret.getS2KUsage() == 254;
                byte[] check = PGPSecretKey.checksum(useSHA1 ? decryptorFactory.getChecksumCalculator(2) : null, data, useSHA1 ? data.length - 20 : data.length - 2);
                int i = 0;
                while (i != check.length) {
                    if (check[i] != data[data.length - check.length + i]) {
                        throw new PGPException("checksum mismatch at " + i + " of " + check.length);
                    }
                    ++i;
                }
                return data;
            }
            byte[] key = decryptorFactory.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
            data = new byte[encData.length];
            byte[] iv = new byte[this.secret.getIV().length];
            System.arraycopy(this.secret.getIV(), 0, iv, 0, iv.length);
            int pos = 0;
            for (int i = 0; i != 4; ++i) {
                int encLen = ((encData[pos] << 8 | encData[pos + 1] & 0xFF) + 7) / 8;
                data[pos] = encData[pos];
                data[pos + 1] = encData[pos + 1];
                byte[] tmp = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, iv, encData, pos + 2, encLen);
                System.arraycopy(tmp, 0, data, pos + 2, tmp.length);
                pos += 2 + encLen;
                if (i == 3) continue;
                System.arraycopy(encData, pos - iv.length, iv, 0, iv.length);
            }
            data[pos] = encData[pos];
            data[pos + 1] = encData[pos + 1];
            int cs = encData[pos] << 8 & 0xFF00 | encData[pos + 1] & 0xFF;
            int calcCs = 0;
            for (int j = 0; j < data.length - 2; ++j) {
                calcCs += data[j] & 0xFF;
            }
            if ((calcCs &= 0xFFFF) == cs) return data;
            throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(cs) + " found " + Integer.toHexString(calcCs));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception decrypting key", e);
        }
    }

    public PGPPrivateKey extractPrivateKey(char[] passPhrase, String provider) throws PGPException, NoSuchProviderException {
        return this.extractPrivateKey(passPhrase, PGPUtil.getProvider(provider));
    }

    public PGPPrivateKey extractPrivateKey(char[] passPhrase, Provider provider) throws PGPException {
        return this.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider(provider).build()).setProvider(provider).build(passPhrase));
    }

    public PGPPrivateKey extractPrivateKey(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        if (this.isPrivateKeyEmpty()) {
            return null;
        }
        PublicKeyPacket pubPk = this.secret.getPublicKeyPacket();
        try {
            byte[] data = this.extractKeyData(decryptorFactory);
            BCPGInputStream in = new BCPGInputStream(new ByteArrayInputStream(data));
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSASecretBCPGKey rsaPriv = new RSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, rsaPriv);
                }
                case 17: {
                    DSASecretBCPGKey dsaPriv = new DSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, dsaPriv);
                }
                case 16: 
                case 20: {
                    ElGamalSecretBCPGKey elPriv = new ElGamalSecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, elPriv);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    private static byte[] checksum(PGPDigestCalculator digCalc, byte[] bytes, int length) throws PGPException {
        if (digCalc != null) {
            OutputStream dOut = digCalc.getOutputStream();
            try {
                dOut.write(bytes, 0, length);
                dOut.close();
            }
            catch (Exception e) {
                throw new PGPException("checksum digest calculation failed: " + e.getMessage(), e);
            }
            return digCalc.getDigest();
        }
        int checksum = 0;
        for (int i = 0; i != length; ++i) {
            checksum += bytes[i] & 0xFF;
        }
        byte[] check = new byte[]{(byte)(checksum >> 8), (byte)checksum};
        return check;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.secret);
        if (this.pub.trustPk != null) {
            out.writePacket(this.pub.trustPk);
        }
        if (this.pub.subSigs == null) {
            int i;
            for (i = 0; i != this.pub.keySigs.size(); ++i) {
                ((PGPSignature)this.pub.keySigs.get(i)).encode(out);
            }
            for (i = 0; i != this.pub.ids.size(); ++i) {
                if (this.pub.ids.get(i) instanceof String) {
                    String id = (String)this.pub.ids.get(i);
                    out.writePacket(new UserIDPacket(id));
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.pub.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.pub.idTrusts.get(i) != null) {
                    out.writePacket((ContainedPacket)this.pub.idTrusts.get(i));
                }
                ArrayList sigs = (ArrayList)this.pub.idSigs.get(i);
                for (int j = 0; j != sigs.size(); ++j) {
                    ((PGPSignature)sigs.get(j)).encode(out);
                }
            }
        } else {
            for (int j = 0; j != this.pub.subSigs.size(); ++j) {
                ((PGPSignature)this.pub.subSigs.get(j)).encode(out);
            }
        }
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, String provider) throws PGPException, NoSuchProviderException {
        return PGPSecretKey.copyWithNewPassword(key, oldPassPhrase, newPassPhrase, newEncAlgorithm, rand, PGPUtil.getProvider(provider));
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        byte[] keyData;
        if (key.isPrivateKeyEmpty()) {
            throw new PGPException("no private key in this SecretKey - public key present only.");
        }
        byte[] rawKeyData = key.extractKeyData(oldKeyDecryptor);
        int s2kUsage = key.secret.getS2KUsage();
        byte[] iv = null;
        S2K s2k = null;
        int newEncAlgorithm = 0;
        if (newKeyEncryptor == null || newKeyEncryptor.getAlgorithm() == 0) {
            s2kUsage = 0;
            if (key.secret.getS2KUsage() == 254) {
                keyData = new byte[rawKeyData.length - 18];
                System.arraycopy(rawKeyData, 0, keyData, 0, keyData.length - 2);
                byte[] check = PGPSecretKey.checksum(null, keyData, keyData.length - 2);
                keyData[keyData.length - 2] = check[0];
                keyData[keyData.length - 1] = check[1];
            } else {
                keyData = rawKeyData;
            }
        } else if (key.secret.getPublicKeyPacket().getVersion() < 4) {
            byte[] encKey = newKeyEncryptor.getKey();
            keyData = new byte[rawKeyData.length];
            if (newKeyEncryptor.getHashAlgorithm() != 1) {
                throw new PGPException("MD5 Digest Calculator required for version 3 key encryptor.");
            }
            int pos = 0;
            for (int i = 0; i != 4; ++i) {
                byte[] tmp;
                int encLen = ((rawKeyData[pos] << 8 | rawKeyData[pos + 1] & 0xFF) + 7) / 8;
                keyData[pos] = rawKeyData[pos];
                keyData[pos + 1] = rawKeyData[pos + 1];
                if (i == 0) {
                    tmp = newKeyEncryptor.encryptKeyData(encKey, rawKeyData, pos + 2, encLen);
                    iv = newKeyEncryptor.getCipherIV();
                } else {
                    byte[] tmpIv = new byte[iv.length];
                    System.arraycopy(keyData, pos - iv.length, tmpIv, 0, tmpIv.length);
                    tmp = newKeyEncryptor.encryptKeyData(encKey, tmpIv, rawKeyData, pos + 2, encLen);
                }
                System.arraycopy(tmp, 0, keyData, pos + 2, tmp.length);
                pos += 2 + encLen;
            }
            keyData[pos] = rawKeyData[pos];
            keyData[pos + 1] = rawKeyData[pos + 1];
            s2k = newKeyEncryptor.getS2K();
            newEncAlgorithm = newKeyEncryptor.getAlgorithm();
        } else {
            keyData = newKeyEncryptor.encryptKeyData(rawKeyData, 0, rawKeyData.length);
            iv = newKeyEncryptor.getCipherIV();
            s2k = newKeyEncryptor.getS2K();
            newEncAlgorithm = newKeyEncryptor.getAlgorithm();
        }
        SecretKeyPacket secret = key.secret instanceof SecretSubkeyPacket ? new SecretSubkeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData) : new SecretKeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData);
        return new PGPSecretKey(secret, key.pub);
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, char[] oldPassPhrase, char[] newPassPhrase, int newEncAlgorithm, SecureRandom rand, Provider provider) throws PGPException {
        return PGPSecretKey.copyWithNewPassword(key, new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider(provider).build()).setProvider(provider).build(oldPassPhrase), new JcePBESecretKeyEncryptorBuilder(newEncAlgorithm).setProvider(provider).setSecureRandom(rand).build(newPassPhrase));
    }

    public static PGPSecretKey replacePublicKey(PGPSecretKey secretKey, PGPPublicKey publicKey) {
        if (publicKey.getKeyID() != secretKey.getKeyID()) {
            throw new IllegalArgumentException("keyIDs do not match");
        }
        return new PGPSecretKey(secretKey.secret, publicKey);
    }
}

