/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Date;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.bcpg.OnePassSignaturePacket;
import org.spongycastle.bcpg.SignaturePacket;
import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.bcpg.UserAttributeSubpacket;
import org.spongycastle.bcpg.sig.IssuerKeyID;
import org.spongycastle.bcpg.sig.SignatureCreationTime;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPOnePassSignature;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureSubpacketVector;
import org.spongycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.PGPContentSigner;
import org.spongycastle.openpgp.operator.PGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.spongycastle.util.Strings;

public class PGPSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private byte lastb;
    private int providedKeyAlgorithm = -1;

    public PGPSignatureGenerator(int keyAlgorithm, int hashAlgorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, provider, hashAlgorithm, provider);
    }

    public PGPSignatureGenerator(int keyAlgorithm, int hashAlgorithm, Provider provider) throws NoSuchAlgorithmException, PGPException {
        this(keyAlgorithm, provider, hashAlgorithm, provider);
    }

    public PGPSignatureGenerator(int keyAlgorithm, String sigProvider, int hashAlgorithm, String digProvider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, PGPUtil.getProvider(sigProvider), hashAlgorithm, PGPUtil.getProvider(digProvider));
    }

    public PGPSignatureGenerator(int keyAlgorithm, Provider sigProvider, int hashAlgorithm, Provider digProvider) throws NoSuchAlgorithmException, PGPException {
        this.providedKeyAlgorithm = keyAlgorithm;
        this.contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm).setProvider(sigProvider).setDigestProvider(digProvider);
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder contentSignerBuilder) {
        this.contentSignerBuilder = contentSignerBuilder;
    }

    public void initSign(int signatureType, PGPPrivateKey key) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(signatureType, key);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void init(int signatureType, PGPPrivateKey key) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(signatureType, key);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void initSign(int signatureType, PGPPrivateKey key, SecureRandom random) throws PGPException {
        this.initSign(signatureType, key);
    }

    public void update(byte b) throws SignatureException {
        if (this.sigType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) throws SignatureException {
        if (this.sigType == 1) {
            int finish = off + len;
            for (int i = off; i != finish; ++i) {
                this.update(b[i]);
            }
        } else {
            this.blockUpdate(b, off, len);
        }
    }

    private void byteUpdate(byte b) throws SignatureException {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    private void blockUpdate(byte[] block, int off, int len) throws SignatureException {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector hashedPcks) {
        if (hashedPcks == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = hashedPcks.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector unhashedPcks) {
        if (unhashedPcks == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = unhashedPcks.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), isNested));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        int version = 4;
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        SignatureSubpacket[] hPkts = !this.packetPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] unhPkts = !this.packetPresent(this.hashed, 16) && !this.packetPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID())) : this.unhashed;
        try {
            sOut.write((byte)version);
            sOut.write((byte)this.sigType);
            sOut.write((byte)this.contentSigner.getKeyAlgorithm());
            sOut.write((byte)this.contentSigner.getHashAlgorithm());
            ByteArrayOutputStream hOut = new ByteArrayOutputStream();
            for (int i = 0; i != hPkts.length; ++i) {
                hPkts[i].encode(hOut);
            }
            byte[] data = hOut.toByteArray();
            sOut.write((byte)(data.length >> 8));
            sOut.write((byte)data.length);
            sOut.write(data);
        }
        catch (IOException e) {
            throw new PGPException("exception encoding hashed data.", e);
        }
        byte[] hData = sOut.toByteArray();
        sOut.write((byte)version);
        sOut.write(-1);
        sOut.write((byte)(hData.length >> 24));
        sOut.write((byte)(hData.length >> 16));
        sOut.write((byte)(hData.length >> 8));
        sOut.write((byte)hData.length);
        byte[] trailer = sOut.toByteArray();
        this.blockUpdate(trailer, 0, trailer.length);
        MPInteger[] sigValues = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] digest = this.contentSigner.getDigest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        return new PGPSignature(new SignaturePacket(this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), hPkts, unhPkts, fingerPrint, sigValues));
    }

    public PGPSignature generateCertification(String id, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pubKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray((String)id));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pubKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pubKey) throws SignatureException, PGPException {
        if (!(this.sigType != 40 && this.sigType != 24 || pubKey.isMasterKey())) {
            throw new IllegalArgumentException("certifications involving subkey requires public key of revoking key as well.");
        }
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }

    private boolean packetPresent(SignatureSubpacket[] packets, int type) {
        for (int i = 0; i != packets.length; ++i) {
            if (packets[i].getType() != type) continue;
            return true;
        }
        return false;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] packets, SignatureSubpacket subpacket) {
        SignatureSubpacket[] tmp = new SignatureSubpacket[packets.length + 1];
        tmp[0] = subpacket;
        System.arraycopy(packets, 0, tmp, 1, packets.length);
        return tmp;
    }

    private void updateWithIdData(int header, byte[] idBytes) throws SignatureException {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    private void updateWithPublicKey(PGPPublicKey key) throws PGPException, SignatureException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        this.update((byte)-103);
        this.update((byte)(keyBytes.length >> 8));
        this.update((byte)keyBytes.length);
        this.update(keyBytes);
    }
}

