/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Date;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.bcpg.OnePassSignaturePacket;
import org.spongycastle.bcpg.SignaturePacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPOnePassSignature;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.PGPContentSigner;
import org.spongycastle.openpgp.operator.PGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;

public class PGPV3SignatureGenerator {
    private byte lastb;
    private OutputStream sigOut;
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int sigType;
    private int providedKeyAlgorithm = -1;

    public PGPV3SignatureGenerator(int keyAlgorithm, int hashAlgorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(keyAlgorithm, hashAlgorithm, PGPUtil.getProvider(provider));
    }

    public PGPV3SignatureGenerator(int keyAlgorithm, int hashAlgorithm, Provider provider) throws NoSuchAlgorithmException, PGPException {
        this.providedKeyAlgorithm = keyAlgorithm;
        this.contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm).setProvider(provider);
    }

    public PGPV3SignatureGenerator(PGPContentSignerBuilder contentSignerBuilder) {
        this.contentSignerBuilder = contentSignerBuilder;
    }

    public void init(int signatureType, PGPPrivateKey key) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(signatureType, key);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void initSign(int signatureType, PGPPrivateKey key, SecureRandom random) throws PGPException {
        this.init(signatureType, key);
    }

    public void initSign(int signatureType, PGPPrivateKey key) throws PGPException {
        this.init(signatureType, key);
    }

    public void update(byte b) throws SignatureException {
        if (this.sigType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) throws SignatureException {
        if (this.sigType == 1) {
            int finish = off + len;
            for (int i = off; i != finish; ++i) {
                this.update(b[i]);
            }
        } else {
            this.blockUpdate(b, off, len);
        }
    }

    private void byteUpdate(byte b) throws SignatureException {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to update signature");
        }
    }

    private void blockUpdate(byte[] block, int off, int len) throws SignatureException {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to update signature");
        }
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), isNested));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        long creationTime = new Date().getTime() / 1000L;
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        sOut.write(this.sigType);
        sOut.write((byte)(creationTime >> 24));
        sOut.write((byte)(creationTime >> 16));
        sOut.write((byte)(creationTime >> 8));
        sOut.write((byte)creationTime);
        byte[] hData = sOut.toByteArray();
        this.blockUpdate(hData, 0, hData.length);
        MPInteger[] sigValues = this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))} : PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        byte[] digest = this.contentSigner.getDigest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        return new PGPSignature(new SignaturePacket(3, this.contentSigner.getType(), this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), creationTime * 1000L, fingerPrint, sigValues));
    }
}

