/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.spongycastle.bcpg.ArmoredOutputStream;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openpgp.PGPCompressedData;
import org.spongycastle.openpgp.PGPCompressedDataGenerator;
import org.spongycastle.openpgp.PGPEncryptedDataGenerator;
import org.spongycastle.openpgp.PGPEncryptedDataList;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPLiteralData;
import org.spongycastle.openpgp.PGPLiteralDataGenerator;
import org.spongycastle.openpgp.PGPObjectFactory;
import org.spongycastle.openpgp.PGPPBEEncryptedData;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.spongycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.spongycastle.util.encoders.Hex;
import org.spongycastle.util.io.Streams;

public class ByteArrayHandler {
    public static byte[] decrypt(byte[] encrypted, char[] passPhrase) throws IOException, PGPException, NoSuchProviderException {
        InputStream in = new ByteArrayInputStream(encrypted);
        PGPObjectFactory pgpF = new PGPObjectFactory(in = PGPUtil.getDecoderStream(in));
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        InputStream clear = pbe.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("SC").build()).setProvider("SC").build(passPhrase));
        PGPObjectFactory pgpFact = new PGPObjectFactory(clear);
        PGPCompressedData cData = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new PGPObjectFactory(cData.getDataStream());
        PGPLiteralData ld = (PGPLiteralData)pgpFact.nextObject();
        return Streams.readAll((InputStream)ld.getInputStream());
    }

    public static byte[] encrypt(byte[] clearData, char[] passPhrase, String fileName, int algorithm, boolean armor) throws IOException, PGPException, NoSuchProviderException {
        if (fileName == null) {
            fileName = "_CONSOLE";
        }
        byte[] compressedData = ByteArrayHandler.compress(clearData, fileName, 1);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream out = bOut;
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(algorithm).setSecureRandom(new SecureRandom()).setProvider("SC"));
        encGen.addMethod(new JcePBEKeyEncryptionMethodGenerator(passPhrase).setProvider("SC"));
        OutputStream encOut = encGen.open(out, compressedData.length);
        encOut.write(compressedData);
        encOut.close();
        if (armor) {
            out.close();
        }
        return bOut.toByteArray();
    }

    private static byte[] compress(byte[] clearData, String fileName, int algorithm) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(algorithm);
        OutputStream cos = comData.open(bOut);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(cos, 'b', fileName, clearData.length, new Date());
        pOut.write(clearData);
        pOut.close();
        comData.close();
        return bOut.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String passPhrase = "Dick Beck";
        char[] passArray = passPhrase.toCharArray();
        byte[] original = "Hello world".getBytes();
        System.out.println("Starting PGP test");
        byte[] encrypted = ByteArrayHandler.encrypt(original, passArray, "iway", 3, true);
        System.out.println("\nencrypted data = '" + new String(encrypted) + "'");
        byte[] decrypted = ByteArrayHandler.decrypt(encrypted, passArray);
        System.out.println("\ndecrypted data = '" + new String(decrypted) + "'");
        encrypted = ByteArrayHandler.encrypt(original, passArray, "iway", 9, false);
        System.out.println("\nencrypted data = '" + new String(Hex.encode((byte[])encrypted)) + "'");
        decrypted = ByteArrayHandler.decrypt(encrypted, passArray);
        System.out.println("\ndecrypted data = '" + new String(decrypted) + "'");
    }
}

