/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.spongycastle.bcpg.ArmoredOutputStream;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.sig.NotationData;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.PGPSecretKey;
import org.spongycastle.openpgp.PGPSecretKeyRing;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureGenerator;
import org.spongycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.spongycastle.openpgp.PGPSignatureSubpacketVector;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class DirectKeySignature {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args.length == 1) {
            PGPPublicKeyRing ring = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = ring.getPublicKey();
            Iterator iter = key.getSignaturesOfType(31);
            while (iter.hasNext()) {
                PGPSignature sig = (PGPSignature)iter.next();
                System.out.println("Signature date is: " + sig.getHashedSubPackets().getSignatureCreationTime());
                NotationData[] data = sig.getHashedSubPackets().getNotationDataOccurences();
                for (int i = 0; i < data.length; ++i) {
                    System.out.println("Found Notaion named '" + data[i].getNotationName() + "' with content '" + data[i].getNotationValue() + "'.");
                }
            }
        } else if (args.length == 5) {
            PGPPublicKeyRing sRing;
            PGPSecretKeyRing secRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String secretKeyPass = args[1];
            PGPPublicKeyRing ring = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[2])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String notationName = args[3];
            String notationValue = args[4];
            ring = sRing = new PGPPublicKeyRing(new ByteArrayInputStream(DirectKeySignature.signPublicKey(secRing.getSecretKey(), secretKeyPass, ring.getPublicKey(), notationName, notationValue, true)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            ArmoredOutputStream out = new ArmoredOutputStream(new FileOutputStream("SignedKey.asc"));
            sRing.encode(out);
            out.flush();
            out.close();
        } else {
            System.err.println("usage: DirectKeySignature secretKeyFile secretKeyPass publicKeyFile(key to be signed) NotationName NotationValue");
            System.err.println("or: DirectKeySignature signedPublicKeyFile");
        }
    }

    private static byte[] signPublicKey(PGPSecretKey secretKey, String secretKeyPass, PGPPublicKey keyToBeSigned, String notationName, String notationValue, boolean armor) throws Exception {
        OutputStream out = new ByteArrayOutputStream();
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        PGPPrivateKey pgpPrivKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("SC").build(secretKeyPass.toCharArray()));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 2).setProvider("SC"));
        sGen.init(31, pgpPrivKey);
        BCPGOutputStream bOut = new BCPGOutputStream(out);
        sGen.generateOnePassVersion(false).encode(bOut);
        PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
        boolean isHumanReadable = true;
        spGen.setNotationData(true, isHumanReadable, notationName, notationValue);
        PGPSignatureSubpacketVector packetVector = spGen.generate();
        sGen.setHashedSubpackets(packetVector);
        bOut.flush();
        if (armor) {
            out.close();
        }
        return PGPPublicKey.addCertification(keyToBeSigned, sGen.generate()).getEncoded();
    }
}

