/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.util.Date;
import org.spongycastle.crypto.AsymmetricCipherKeyPair;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKeyPair;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.operator.bc.BcPGPKeyConverter;

public class BcPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int algorithm, AsymmetricKeyParameter pubKey, Date date) throws PGPException {
        return new BcPGPKeyConverter().getPGPPublicKey(algorithm, pubKey, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pub, AsymmetricKeyParameter privKey) throws PGPException {
        return new BcPGPKeyConverter().getPGPPrivateKey(pub, privKey);
    }

    public BcPGPKeyPair(int algorithm, AsymmetricCipherKeyPair keyPair, Date date) throws PGPException {
        this.pub = BcPGPKeyPair.getPublicKey(algorithm, keyPair.getPublic(), date);
        this.priv = BcPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }
}

