/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedAsymmetricBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.spongycastle.openpgp.operator.bc.BcImplProvider;
import org.spongycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.spongycastle.openpgp.operator.bc.BcUtil;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private PGPPrivateKey privKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey privKey) {
        this.privKey = privKey;
    }

    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        try {
            AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(keyAlgorithm);
            AsymmetricKeyParameter key = this.keyConverter.getPrivateKey(this.privKey);
            BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(c);
            c1.init(false, (CipherParameters)key);
            if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                byte[] bi = secKeyData[0];
                c1.processBytes(bi, 2, bi.length - 2);
            } else {
                BcPGPKeyConverter converter = new BcPGPKeyConverter();
                ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)converter.getPrivateKey(this.privKey);
                int size = (parms.getParameters().getP().bitLength() + 7) / 8;
                byte[] tmp = new byte[size];
                byte[] bi = secKeyData[0];
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
                bi = secKeyData[1];
                for (int i = 0; i != tmp.length; ++i) {
                    tmp[i] = 0;
                }
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
            }
            return c1.doFinal();
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }
}

