/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.io.InputStream;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.io.CipherInputStream;
import org.spongycastle.crypto.modes.CFBBlockCipher;
import org.spongycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean forEncryption, BlockCipher engine, boolean withIntegrityPacket, byte[] key) {
        BufferedBlockCipher c = withIntegrityPacket ? new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(engine, engine.getBlockSize() * 8)) : new BufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(engine));
        KeyParameter keyParameter = new KeyParameter(key);
        if (withIntegrityPacket) {
            c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[engine.getBlockSize()]));
        } else {
            c.init(forEncryption, (CipherParameters)keyParameter);
        }
        return c;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, BlockCipher engine, byte[] key) {
        final BufferedBlockCipher c = BcUtil.createStreamCipher(false, engine, withIntegrityPacket, key);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream in) {
                return new CipherInputStream(in, c);
            }

            public int getBlockSize() {
                return c.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean forEncryption, BlockCipher engine, byte[] key, byte[] iv) {
        BufferedBlockCipher c = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(engine, engine.getBlockSize() * 8));
        c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        return c;
    }
}

