/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import org.spongycastle.jcajce.DefaultJcaJceHelper;
import org.spongycastle.jcajce.JcaJceHelper;
import org.spongycastle.jcajce.NamedJcaJceHelper;
import org.spongycastle.jcajce.ProviderJcaJceHelper;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.spongycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaPGPDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PGPDigestCalculatorProvider build() throws PGPException {
        return new PGPDigestCalculatorProvider(){

            public PGPDigestCalculator get(final int algorithm) throws PGPException {
                DigestOutputStream stream;
                MessageDigest dig;
                try {
                    dig = JcaPGPDigestCalculatorProviderBuilder.this.helper.createDigest(algorithm);
                    stream = new DigestOutputStream(dig);
                }
                catch (GeneralSecurityException e) {
                    throw new PGPException("exception on setup: " + e, e);
                }
                return new PGPDigestCalculator(){

                    public int getAlgorithm() {
                        return algorithm;
                    }

                    public OutputStream getOutputStream() {
                        return stream;
                    }

                    public byte[] getDigest() {
                        return stream.getDigest();
                    }

                    public void reset() {
                        dig.reset();
                    }
                };
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

