/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.x9.ECNamedCurveTable;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.crypto.ec.CustomNamedCurves;
import org.spongycastle.math.ec.ECAlgorithms;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.BigIntegers;

public abstract class ECPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    ASN1ObjectIdentifier oid;
    ECPoint point;

    protected ECPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.oid = ASN1ObjectIdentifier.getInstance((Object)ASN1Primitive.fromByteArray((byte[])ECPublicBCPGKey.readBytesOfEncodedLength(in)));
        this.point = ECPublicBCPGKey.decodePoint(new MPInteger(in).getValue(), this.oid);
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, ECPoint point) {
        this.point = point.normalize();
        this.oid = oid;
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, BigInteger encodedPoint) throws IOException {
        this.point = ECPublicBCPGKey.decodePoint(encodedPoint, oid);
        this.oid = oid;
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void encode(BCPGOutputStream out) throws IOException {
        byte[] oid = this.oid.getEncoded();
        out.write(oid, 1, oid.length - 1);
        MPInteger point = new MPInteger(new BigInteger(1, this.point.getEncoded()));
        out.writeObject(point);
    }

    public ECPoint getPoint() {
        return this.point;
    }

    public ASN1ObjectIdentifier getCurveOID() {
        return this.oid;
    }

    protected static byte[] readBytesOfEncodedLength(BCPGInputStream in) throws IOException {
        int length = in.read();
        if (length == 0 || length == 255) {
            throw new IOException("future extensions not yet implemented.");
        }
        byte[] buffer = new byte[length + 2];
        in.readFully(buffer, 2, buffer.length - 2);
        buffer[0] = 6;
        buffer[1] = (byte)length;
        return buffer;
    }

    private static ECPoint decodePoint(BigInteger encodedPoint, ASN1ObjectIdentifier oid) throws IOException {
        X9ECParameters x9 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)oid);
        if (x9 == null && (x9 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)oid)) == null) {
            throw new IOException(oid.getId() + " does not match any known curve.");
        }
        if (!ECAlgorithms.isFpCurve((ECCurve)x9.getCurve())) {
            throw new IOException("Only prime field curves are supported.");
        }
        return x9.getCurve().decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)encodedPoint));
    }
}

