/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.bcpg.SignatureSubpacketTags;
import org.spongycastle.bcpg.sig.Exportable;
import org.spongycastle.bcpg.sig.IssuerKeyID;
import org.spongycastle.bcpg.sig.KeyExpirationTime;
import org.spongycastle.bcpg.sig.KeyFlags;
import org.spongycastle.bcpg.sig.NotationData;
import org.spongycastle.bcpg.sig.PreferredAlgorithms;
import org.spongycastle.bcpg.sig.PrimaryUserID;
import org.spongycastle.bcpg.sig.Revocable;
import org.spongycastle.bcpg.sig.SignatureCreationTime;
import org.spongycastle.bcpg.sig.SignatureExpirationTime;
import org.spongycastle.bcpg.sig.SignerUserID;
import org.spongycastle.bcpg.sig.TrustSignature;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    InputStream in;

    public SignatureSubpacketInputStream(InputStream in) {
        this.in = in;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        int l = this.read();
        int bodyLen = 0;
        if (l < 0) {
            return null;
        }
        if (l < 192) {
            bodyLen = l;
        } else if (l <= 223) {
            bodyLen = (l - 192 << 8) + this.in.read() + 192;
        } else if (l == 255) {
            bodyLen = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        }
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        int bytesRead = Streams.readFully((InputStream)this.in, (byte[])data);
        boolean isCritical = (tag & 0x80) != 0;
        int type = tag & 0x7F;
        if (bytesRead != data.length) {
            switch (type) {
                case 2: {
                    data = this.checkData(data, 4, bytesRead, "Signature Creation Time");
                    break;
                }
                case 16: {
                    data = this.checkData(data, 8, bytesRead, "Issuer");
                    break;
                }
                case 9: {
                    data = this.checkData(data, 4, bytesRead, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    data = this.checkData(data, 4, bytesRead, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        switch (type) {
            case 2: {
                return new SignatureCreationTime(isCritical, data);
            }
            case 9: {
                return new KeyExpirationTime(isCritical, data);
            }
            case 3: {
                return new SignatureExpirationTime(isCritical, data);
            }
            case 7: {
                return new Revocable(isCritical, data);
            }
            case 4: {
                return new Exportable(isCritical, data);
            }
            case 16: {
                return new IssuerKeyID(isCritical, data);
            }
            case 5: {
                return new TrustSignature(isCritical, data);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(type, isCritical, data);
            }
            case 27: {
                return new KeyFlags(isCritical, data);
            }
            case 25: {
                return new PrimaryUserID(isCritical, data);
            }
            case 28: {
                return new SignerUserID(isCritical, data);
            }
            case 20: {
                return new NotationData(isCritical, data);
            }
        }
        return new SignatureSubpacket(type, isCritical, data);
    }

    private byte[] checkData(byte[] data, int expected, int bytesRead, String name) throws EOFException {
        if (bytesRead != expected) {
            throw new EOFException("truncated " + name + " subpacket data.");
        }
        return Arrays.copyOfRange((byte[])data, (int)0, (int)expected);
    }
}

