/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.ContainedPacket;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.bcpg.PublicSubkeyPacket;
import org.spongycastle.bcpg.SecretKeyPacket;
import org.spongycastle.bcpg.SecretSubkeyPacket;
import org.spongycastle.bcpg.TrustPacket;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKeyRing;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.PGPSecretKey;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.spongycastle.openpgp.operator.PBESecretKeyEncryptor;

public class PGPSecretKeyRing
extends PGPKeyRing {
    List keys;
    List extraPubKeys;

    PGPSecretKeyRing(List keys) {
        this(keys, new ArrayList());
    }

    private PGPSecretKeyRing(List keys, List extraPubKeys) {
        this.keys = keys;
        this.extraPubKeys = extraPubKeys;
    }

    public PGPSecretKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream pIn = PGPSecretKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 5 && initialTag != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        SecretKeyPacket secret = (SecretKeyPacket)pIn.readPacket();
        while (pIn.nextPacketTag() == 61) {
            pIn.readPacket();
        }
        TrustPacket trust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPSecretKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPSecretKey(secret, new PGPPublicKey(secret.getPublicKeyPacket(), trust, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator)));
        while (pIn.nextPacketTag() == 7 || pIn.nextPacketTag() == 14) {
            List sigList;
            TrustPacket subTrust;
            ContainedPacket sub;
            if (pIn.nextPacketTag() == 7) {
                sub = (SecretSubkeyPacket)pIn.readPacket();
                while (pIn.nextPacketTag() == 61) {
                    pIn.readPacket();
                }
                subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)sub, new PGPPublicKey(((SecretKeyPacket)sub).getPublicKeyPacket(), subTrust, sigList, fingerPrintCalculator)));
                continue;
            }
            sub = (PublicSubkeyPacket)pIn.readPacket();
            subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
            sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)sub, subTrust, sigList, fingerPrintCalculator));
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPPublicKey getPublicKey(long keyID) {
        PGPSecretKey key = this.getSecretKey(keyID);
        if (key != null) {
            return key.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        Iterator it = this.getSecretKeys();
        while (it.hasNext()) {
            pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        }
        pubKeys.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(pubKeys).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long keyId) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (keyId != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public Iterator getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        Object k;
        int i;
        for (i = 0; i != this.keys.size(); ++i) {
            k = (PGPSecretKey)this.keys.get(i);
            ((PGPSecretKey)k).encode(outStream);
        }
        for (i = 0; i != this.extraPubKeys.size(); ++i) {
            k = (PGPPublicKey)this.extraPubKeys.get(i);
            ((PGPPublicKey)k).encode(outStream);
        }
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing secretRing, PGPPublicKeyRing publicRing) {
        ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
        for (PGPSecretKey sk : secretRing.keys) {
            PGPPublicKey pk = publicRing.getPublicKey(sk.getKeyID());
            newList.add(PGPSecretKey.replacePublicKey(sk, pk));
        }
        return new PGPSecretKeyRing(newList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> newKeys = new ArrayList<PGPSecretKey>(ring.keys.size());
        Iterator keys = ring.getSecretKeys();
        while (keys.hasNext()) {
            PGPSecretKey key = (PGPSecretKey)keys.next();
            if (key.isPrivateKeyEmpty()) {
                newKeys.add(key);
                continue;
            }
            newKeys.add(PGPSecretKey.copyWithNewPassword(key, oldKeyDecryptor, newKeyEncryptor));
        }
        return new PGPSecretKeyRing(newKeys, ring.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>(secRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.set(i, secKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (secKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, secKey);
            } else {
                keys.add(secKey);
            }
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList keys = new ArrayList(secRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() != secKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }
}

