/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.examples;

import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.PGPPublicKeyRingCollection;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.spongycastle.util.encoders.Hex;

public class PubringDump {
    public static String getAlgorithm(int algId) {
        switch (algId) {
            case 1: {
                return "RSA_GENERAL";
            }
            case 2: {
                return "RSA_ENCRYPT";
            }
            case 3: {
                return "RSA_SIGN";
            }
            case 16: {
                return "ELGAMAL_ENCRYPT";
            }
            case 17: {
                return "DSA";
            }
            case 18: {
                return "EC";
            }
            case 19: {
                return "ECDSA";
            }
            case 20: {
                return "ELGAMAL_GENERAL";
            }
            case 21: {
                return "DIFFIE_HELLMAN";
            }
        }
        return "unknown";
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPUtil.setDefaultProvider("SC");
        PGPPublicKeyRingCollection pubRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator rIt = pubRings.getKeyRings();
        while (rIt.hasNext()) {
            PGPPublicKeyRing pgpPub = (PGPPublicKeyRing)rIt.next();
            try {
                pgpPub.getPublicKey();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            Iterator it = pgpPub.getPublicKeys();
            boolean first = true;
            while (it.hasNext()) {
                PGPPublicKey pgpKey = (PGPPublicKey)it.next();
                if (first) {
                    System.out.println("Key ID: " + Long.toHexString(pgpKey.getKeyID()));
                    first = false;
                } else {
                    System.out.println("Key ID: " + Long.toHexString(pgpKey.getKeyID()) + " (subkey)");
                }
                System.out.println("            Algorithm: " + PubringDump.getAlgorithm(pgpKey.getAlgorithm()));
                System.out.println("            Fingerprint: " + new String(Hex.encode((byte[])pgpKey.getFingerprint())));
            }
        }
    }
}

