/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.nist.NISTNamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.bcpg.ECDHPublicBCPGKey;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.EphemeralKeyPair;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.KeyEncoder;
import org.spongycastle.crypto.KeyGenerationParameters;
import org.spongycastle.crypto.Wrapper;
import org.spongycastle.crypto.generators.ECKeyPairGenerator;
import org.spongycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECKeyGenerationParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.operator.PGPPad;
import org.spongycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.spongycastle.openpgp.operator.RFC6637KDFCalculator;
import org.spongycastle.openpgp.operator.bc.BcImplProvider;
import org.spongycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.spongycastle.openpgp.operator.bc.BcPGPKeyConverter;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionInfo) throws PGPException {
        try {
            if (pubKey.getAlgorithm() != 18) {
                AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(pubKey.getAlgorithm());
                AsymmetricKeyParameter key = this.keyConverter.getPublicKey(pubKey);
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)key, this.random));
                return c.processBlock(sessionInfo, 0, sessionInfo.length);
            }
            ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
            X9ECParameters x9Params = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)ecKey.getCurveOID());
            ECDomainParameters ecParams = new ECDomainParameters(x9Params.getCurve(), x9Params.getG(), x9Params.getN());
            ECKeyPairGenerator gen = new ECKeyPairGenerator();
            gen.init((KeyGenerationParameters)new ECKeyGenerationParameters(ecParams, this.random));
            EphemeralKeyPairGenerator kGen = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)gen, new KeyEncoder(){

                public byte[] getEncoded(AsymmetricKeyParameter keyParameter) {
                    return ((ECPublicKeyParameters)keyParameter).getQ().getEncoded(false);
                }
            });
            EphemeralKeyPair ephKp = kGen.generate();
            ECPrivateKeyParameters ephPriv = (ECPrivateKeyParameters)ephKp.getKeyPair().getPrivate();
            ECPoint S = ecKey.getPoint().multiply(ephPriv.getD()).normalize();
            RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(ecKey.getHashAlgorithm()), ecKey.getSymmetricKeyAlgorithm());
            KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(ecKey.getCurveOID(), S, pubKey.getFingerprint()));
            Wrapper c = BcImplProvider.createWrapper(ecKey.getSymmetricKeyAlgorithm());
            c.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)key, this.random));
            byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo);
            byte[] C = c.wrap(paddedSessionData, 0, paddedSessionData.length);
            byte[] VB = new MPInteger(new BigInteger(1, ephKp.getEncodedPublicKey())).getEncoded();
            byte[] rv = new byte[VB.length + 1 + C.length];
            System.arraycopy(VB, 0, rv, 0, VB.length);
            rv[VB.length] = (byte)C.length;
            System.arraycopy(C, 0, rv, VB.length + 1, C.length);
            return rv;
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new PGPException("exception encrypting session info: " + e.getMessage(), e);
        }
    }
}

