/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.bcpg.ArmoredInputStream;
import org.spongycastle.bcpg.HashAlgorithmTags;
import org.spongycastle.bcpg.MPInteger;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPLiteralDataGenerator;
import org.spongycastle.util.encoders.Base64;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "SC";
    private static final int READ_AHEAD = 60;

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String provider) {
        defProvider = provider;
    }

    static MPInteger[] dsaSigToMpi(byte[] encoding) throws PGPException {
        ASN1Integer i2;
        ASN1Integer i1;
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        try {
            ASN1Sequence s = (ASN1Sequence)aIn.readObject();
            i1 = (ASN1Integer)s.getObjectAt(0);
            i2 = (ASN1Integer)s.getObjectAt(1);
        }
        catch (IOException e) {
            throw new PGPException("exception encoding signature", e);
        }
        MPInteger[] values = new MPInteger[]{new MPInteger(i1.getValue()), new MPInteger(i2.getValue())};
        return values;
    }

    static String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    static String getSignatureName(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg;
    }

    public static byte[] makeRandomKey(int algorithm, SecureRandom random) throws PGPException {
        int keySize = 0;
        switch (algorithm) {
            case 2: {
                keySize = 192;
                break;
            }
            case 1: {
                keySize = 128;
                break;
            }
            case 3: {
                keySize = 128;
                break;
            }
            case 4: {
                keySize = 128;
                break;
            }
            case 5: {
                keySize = 128;
                break;
            }
            case 6: {
                keySize = 64;
                break;
            }
            case 7: {
                keySize = 128;
                break;
            }
            case 8: {
                keySize = 192;
                break;
            }
            case 9: {
                keySize = 256;
                break;
            }
            case 11: {
                keySize = 128;
                break;
            }
            case 12: {
                keySize = 192;
                break;
            }
            case 13: {
                keySize = 256;
                break;
            }
            case 10: {
                keySize = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        random.nextBytes(keyBytes);
        return keyBytes;
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file);
        PGPUtil.pipeFileContents(file, pOut, 4096);
    }

    public static void writeFileToLiteralData(OutputStream out, char fileType, File file, byte[] buffer) throws IOException {
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(out, fileType, file.getName(), new Date(file.lastModified()), buffer);
        PGPUtil.pipeFileContents(file, pOut, buffer.length);
    }

    private static void pipeFileContents(File file, OutputStream pOut, int bufSize) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[bufSize];
        while ((len = in.read(buf)) > 0) {
            pOut.write(buf, 0, len);
        }
        pOut.close();
        in.close();
    }

    private static boolean isPossiblyBase64(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 43 || ch == 47 || ch == 13 || ch == 10;
    }

    public static InputStream getDecoderStream(InputStream in) throws IOException {
        int count;
        if (!in.markSupported()) {
            in = new BufferedInputStreamExt(in);
        }
        in.mark(60);
        int ch = in.read();
        if ((ch & 0x80) != 0) {
            in.reset();
            return in;
        }
        if (!PGPUtil.isPossiblyBase64(ch)) {
            in.reset();
            return new ArmoredInputStream(in);
        }
        byte[] buf = new byte[60];
        int index = 1;
        buf[0] = (byte)ch;
        for (count = 1; count != 60 && (ch = in.read()) >= 0; ++count) {
            if (!PGPUtil.isPossiblyBase64(ch)) {
                in.reset();
                return new ArmoredInputStream(in);
            }
            if (ch == 10 || ch == 13) continue;
            buf[index++] = (byte)ch;
        }
        in.reset();
        if (count < 4) {
            return new ArmoredInputStream(in);
        }
        byte[] firstBlock = new byte[8];
        System.arraycopy(buf, 0, firstBlock, 0, firstBlock.length);
        byte[] decoded = Base64.decode((byte[])firstBlock);
        if ((decoded[0] & 0x80) != 0) {
            return new ArmoredInputStream(in, false);
        }
        return new ArmoredInputStream(in);
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream input) {
            super(input);
        }

        public synchronized int available() throws IOException {
            int result = super.available();
            if (result < 0) {
                result = Integer.MAX_VALUE;
            }
            return result;
        }
    }
}

