/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.nist.NISTNamedCurves;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.ECDHPublicBCPGKey;
import org.spongycastle.bcpg.ECSecretBCPGKey;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.jcajce.util.NamedJcaJceHelper;
import org.spongycastle.jcajce.util.ProviderJcaJceHelper;
import org.spongycastle.jce.interfaces.ElGamalKey;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PGPPad;
import org.spongycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.spongycastle.openpgp.operator.RFC6637KDFCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.spongycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String providerName) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
                if (keyAlgorithm == 18) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, privKey, secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey privKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
                if (keyAlgorithm == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(privKey.getPrivateKeyDataPacket(), privKey.getPublicKeyPacket(), secKeyData);
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(keyAlgorithm, JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(privKey), secKeyData);
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }
        };
    }

    private byte[] decryptSessionData(BCPGKey privateKeyPacket, PublicKeyPacket pubKeyData, byte[][] secKeyData) throws PGPException {
        ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKeyData.getKey();
        X9ECParameters x9Params = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)ecKey.getCurveOID());
        byte[] enc = secKeyData[0];
        int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 2, pEnc, 0, pLen);
        byte[] keyEnc = new byte[enc[pLen + 2]];
        System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyEnc.length);
        Cipher c = this.helper.createKeyWrapper(ecKey.getSymmetricKeyAlgorithm());
        ECPoint S = x9Params.getCurve().decodePoint(pEnc).multiply(((ECSecretBCPGKey)privateKeyPacket).getX()).normalize();
        RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(this.digestCalculatorProviderBuilder.build().get(ecKey.getHashAlgorithm()), ecKey.getSymmetricKeyAlgorithm());
        SecretKeySpec key = new SecretKeySpec(rfc6637KDFCalculator.createKey(ecKey.getCurveOID(), S, this.fingerprintCalculator.calculateFingerprint(pubKeyData)), "AESWrap");
        try {
            c.init(4, key);
            Key paddedSessionKey = c.unwrap(keyEnc, "Session", 3);
            return PGPPad.unpadSessionData(paddedSessionKey.getEncoded());
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
    }

    private byte[] decryptSessionData(int keyAlgorithm, PrivateKey privKey, byte[][] secKeyData) throws PGPException {
        Cipher c1 = this.helper.createPublicKeyCipher(keyAlgorithm);
        try {
            c1.init(2, privKey);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("error setting asymmetric cipher", e);
        }
        if (keyAlgorithm == 2 || keyAlgorithm == 1) {
            byte[] bi = secKeyData[0];
            c1.update(bi, 2, bi.length - 2);
        } else {
            ElGamalKey k = (ElGamalKey)privKey;
            int size = (k.getParameters().getP().bitLength() + 7) / 8;
            byte[] tmp = new byte[size];
            byte[] bi = secKeyData[0];
            if (bi.length - 2 > size) {
                c1.update(bi, 3, bi.length - 3);
            } else {
                System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                c1.update(tmp);
            }
            bi = secKeyData[1];
            for (int i = 0; i != tmp.length; ++i) {
                tmp[i] = 0;
            }
            if (bi.length - 2 > size) {
                c1.update(bi, 3, bi.length - 3);
            } else {
                System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                c1.update(tmp);
            }
        }
        try {
            return c1.doFinal();
        }
        catch (Exception e) {
            throw new PGPException("exception decrypting session data", e);
        }
    }
}

