/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.x9.ECNamedCurveTable;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.ec.CustomNamedCurves;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.util.BigIntegers;

class PGPUtil {
    PGPUtil() {
    }

    static String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    static String getSignatureName(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg;
    }

    static String getSymmetricCipherName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 11: {
                return "Camellia";
            }
            case 12: {
                return "Camellia";
            }
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + algorithm);
    }

    public static SecretKey makeSymmetricKey(int algorithm, byte[] keyBytes) throws PGPException {
        String algName = PGPUtil.getSymmetricCipherName(algorithm);
        if (algName == null) {
            throw new PGPException("unknown symmetric algorithm: " + algorithm);
        }
        return new SecretKeySpec(keyBytes, algName);
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) throws IOException {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)encodedPoint));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)curveOID);
        if (x9 == null) {
            x9 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOID);
        }
        return x9;
    }
}

