package org.spongycastle.bcpg.sig;

import org.spongycastle.bcpg.SignatureSubpacket;

/**
 * packet giving signature creation time.
 */
public class PreferredAlgorithms 
    extends SignatureSubpacket
{    
    private static byte[] intToByteArray(
        int[]    v)
    {
        byte[]    data = new byte[v.length];
        
        for (int i = 0; i != v.length; i++)
        {
            data[i] = (byte)v[i];
        }
        
        return data;
    }
    
    public PreferredAlgorithms(
        int        type,
        boolean    critical,
        boolean    isLongLength,
        byte[]     data)
    {
        super(type, critical, isLongLength, data);
    }
    
    public PreferredAlgorithms(
        int        type,
        boolean    critical,
        int[]      preferrences)
    {
        super(type, critical, false, intToByteArray(preferrences));
    }
    
    /**
     * @deprecated mispelt!
     */
    public int[] getPreferrences()
    {
        return getPreferences();
    }

    public int[] getPreferences()
    {
        int[]    v = new int[data.length];
        
        for (int i = 0; i != v.length; i++)
        {
            v[i] = data[i] & 0xff;
        }
        
        return v;
    }
}
