/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.StreamGenerator;
import org.spongycastle.openpgp.WrappedGeneratorStream;
import org.spongycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.spongycastle.openpgp.operator.PGPDataEncryptor;
import org.spongycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.spongycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean oldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private List methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder) {
        this(encryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder encryptorBuilder, boolean oldFormat) {
        this.dataEncryptorBuilder = encryptorBuilder;
        this.oldFormat = oldFormat;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator method) {
        this.methods.add(method);
    }

    private void addCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        sessionInfo[sessionInfo.length - 2] = (byte)(check >> 8);
        sessionInfo[sessionInfo.length - 1] = (byte)check;
    }

    private byte[] createSessionInfo(int algorithm, byte[] keyBytes) {
        byte[] sessionInfo = new byte[keyBytes.length + 3];
        sessionInfo[0] = (byte)algorithm;
        System.arraycopy(keyBytes, 0, sessionInfo, 1, keyBytes.length);
        this.addCheckSum(sessionInfo);
        return sessionInfo;
    }

    private OutputStream open(OutputStream out, long length, byte[] buffer) throws IOException, PGPException, IllegalStateException {
        byte[] sessionInfo;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        byte[] key = null;
        this.pOut = new BCPGOutputStream(out);
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator) {
                PBEKeyEncryptionMethodGenerator m = (PBEKeyEncryptionMethodGenerator)this.methods.get(0);
                key = m.getKey(this.dataEncryptorBuilder.getAlgorithm());
                this.pOut.writePacket(((PGPKeyEncryptionMethodGenerator)this.methods.get(0)).generate(this.defAlgorithm, null));
            } else {
                key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
                PGPKeyEncryptionMethodGenerator m = (PGPKeyEncryptionMethodGenerator)this.methods.get(0);
                this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
            }
        } else {
            key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            sessionInfo = this.createSessionInfo(this.defAlgorithm, key);
            for (int i = 0; i != this.methods.size(); ++i) {
                PGPKeyEncryptionMethodGenerator m = (PGPKeyEncryptionMethodGenerator)this.methods.get(i);
                this.pOut.writePacket(m.generate(this.defAlgorithm, sessionInfo));
            }
        }
        try {
            PGPDataEncryptor dataEncryptor = this.dataEncryptorBuilder.build(key);
            this.digestCalc = dataEncryptor.getIntegrityCalculator();
            if (buffer == null) {
                if (this.digestCalc != null) {
                    this.pOut = new ClosableBCPGOutputStream(out, 18, length + (long)dataEncryptor.getBlockSize() + 2L + 1L + 22L);
                    this.pOut.write(1);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(out, 9, length + (long)dataEncryptor.getBlockSize() + 2L, this.oldFormat);
                }
            } else if (this.digestCalc != null) {
                this.pOut = new ClosableBCPGOutputStream(out, 18, buffer);
                this.pOut.write(1);
            } else {
                this.pOut = new ClosableBCPGOutputStream(out, 9, buffer);
            }
            this.genOut = this.cOut = dataEncryptor.getOutputStream(this.pOut);
            if (this.digestCalc != null) {
                this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
            }
            byte[] inLineIv = new byte[dataEncryptor.getBlockSize() + 2];
            this.rand.nextBytes(inLineIv);
            inLineIv[inLineIv.length - 1] = inLineIv[inLineIv.length - 3];
            inLineIv[inLineIv.length - 2] = inLineIv[inLineIv.length - 4];
            this.genOut.write(inLineIv);
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    public OutputStream open(OutputStream out, long length) throws IOException, PGPException {
        return this.open(out, length, null);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        return this.open(out, 0L, buffer);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bOut = new BCPGOutputStream(this.genOut, 19, 20L);
                bOut.flush();
                byte[] dig = this.digestCalc.getDigest();
                this.cOut.write(dig);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream out, int symmetricKeyEnc, byte[] buffer) throws IOException {
            super(out, symmetricKeyEnc, buffer);
        }

        public ClosableBCPGOutputStream(OutputStream out, int symmetricKeyEnc, long length, boolean oldFormat) throws IOException {
            super(out, symmetricKeyEnc, length, oldFormat);
        }

        public ClosableBCPGOutputStream(OutputStream out, int symEncIntegrityPro, long length) throws IOException {
            super(out, symEncIntegrityPro, length);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

