package org.spongycastle.bcpg.sig;

import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.bcpg.SignatureSubpacketTags;
import org.spongycastle.util.Strings;

/**
 * Represents revocation reason OpenPGP signature sub packet.
 */
public class RevocationReason extends SignatureSubpacket
{
    public RevocationReason(boolean isCritical, boolean isLongLength, byte[] data)
    {
        super(SignatureSubpacketTags.REVOCATION_REASON, isCritical, isLongLength, data);
    }

    public RevocationReason(boolean isCritical, byte reason, String description)
    {
        super(SignatureSubpacketTags.REVOCATION_REASON, isCritical, false, createData(reason, description));
    }

    private static byte[] createData(byte reason, String description)
    {
        byte[] descriptionBytes = Strings.toUTF8ByteArray(description);
        byte[] data = new byte[1 + descriptionBytes.length];

        data[0] = reason;
        System.arraycopy(descriptionBytes, 0, data, 1, descriptionBytes.length);

        return data;
    }

    public byte getRevocationReason()
    {
        return getData()[0];
    }

    public String getRevocationDescription()
    {
        byte[] data = getData();
        if (data.length == 1)
        {
            return "";
        }

        byte[] description = new byte[data.length - 1];
        System.arraycopy(data, 1, description, 0, description.length);

        return Strings.fromUTF8ByteArray(description);
    }
}
