/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.spongycastle.bcpg.CRC24;
import org.spongycastle.util.StringList;
import org.spongycastle.util.Strings;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable;
    InputStream in;
    boolean start = true;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    CRC24 crc = new CRC24();
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    StringList headerList = Strings.newList();
    int lastC = 0;
    boolean isEndOfStream;

    private int decode(int in0, int in1, int in2, int in3, int[] out) throws EOFException {
        if (in3 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (in2 == 61) {
            int b1 = decodingTable[in0] & 0xFF;
            int b2 = decodingTable[in1] & 0xFF;
            out[2] = (b1 << 2 | b2 >> 4) & 0xFF;
            return 2;
        }
        if (in3 == 61) {
            byte b1 = decodingTable[in0];
            byte b2 = decodingTable[in1];
            byte b3 = decodingTable[in2];
            out[1] = (b1 << 2 | b2 >> 4) & 0xFF;
            out[2] = (b2 << 4 | b3 >> 2) & 0xFF;
            return 1;
        }
        byte b1 = decodingTable[in0];
        byte b2 = decodingTable[in1];
        byte b3 = decodingTable[in2];
        byte b4 = decodingTable[in3];
        out[0] = (b1 << 2 | b2 >> 4) & 0xFF;
        out[1] = (b2 << 4 | b3 >> 2) & 0xFF;
        out[2] = (b3 << 6 | b4) & 0xFF;
        return 0;
    }

    public ArmoredInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    public ArmoredInputStream(InputStream in, boolean hasHeaders) throws IOException {
        this.in = in;
        this.hasHeaders = hasHeaders;
        if (hasHeaders) {
            this.parseHeaders();
        }
        this.start = false;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private boolean parseHeaders() throws IOException {
        int c;
        this.header = null;
        int last = 0;
        boolean headerFound = false;
        this.headerList = Strings.newList();
        if (this.restart) {
            headerFound = true;
        } else {
            while ((c = this.in.read()) >= 0) {
                if (c == 45 && (last == 0 || last == 10 || last == 13)) {
                    headerFound = true;
                    break;
                }
                last = c;
            }
        }
        if (headerFound) {
            StringBuffer buf = new StringBuffer("-");
            boolean eolReached = false;
            boolean crLf = false;
            if (this.restart) {
                buf.append('-');
            }
            while ((c = this.in.read()) >= 0) {
                if (last == 13 && c == 10) {
                    crLf = true;
                }
                if (eolReached && last != 13 && c == 10 || eolReached && c == 13) break;
                if (c == 13 || last != 13 && c == 10) {
                    String line = buf.toString();
                    if (line.trim().length() == 0) break;
                    this.headerList.add(line);
                    buf.setLength(0);
                }
                if (c != 10 && c != 13) {
                    buf.append((char)c);
                    eolReached = false;
                } else if (c == 13 || last != 13 && c == 10) {
                    eolReached = true;
                }
                last = c;
            }
            if (crLf) {
                this.in.read();
            }
        }
        if (this.headerList.size() > 0) {
            this.header = this.headerList.get(0);
        }
        this.clearText = "-----BEGIN PGP SIGNED MESSAGE-----".equals(this.header);
        this.newLineFound = true;
        return headerFound;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        return this.headerList.toStringArray(1, this.headerList.size());
    }

    private int readIgnoreSpace() throws IOException {
        int c = this.in.read();
        while (c == 32 || c == 9) {
            c = this.in.read();
        }
        return c;
    }

    public int read() throws IOException {
        int c;
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            this.crc.reset();
            this.start = false;
        }
        if (this.clearText) {
            int c2 = this.in.read();
            if (c2 == 13 || c2 == 10 && this.lastC != 13) {
                this.newLineFound = true;
            } else if (this.newLineFound && c2 == 45) {
                c2 = this.in.read();
                if (c2 == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    c2 = this.in.read();
                }
                this.newLineFound = false;
            } else if (c2 != 10 && this.lastC != 13) {
                this.newLineFound = false;
            }
            this.lastC = c2;
            if (c2 < 0) {
                this.isEndOfStream = true;
            }
            return c2;
        }
        if (this.bufPtr > 2 || this.crcFound) {
            c = this.readIgnoreSpace();
            if (c == 13 || c == 10) {
                c = this.readIgnoreSpace();
                while (c == 10 || c == 13) {
                    c = this.readIgnoreSpace();
                }
                if (c < 0) {
                    this.isEndOfStream = true;
                    return -1;
                }
                if (c == 61) {
                    this.bufPtr = this.decode(this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                    if (this.bufPtr == 0) {
                        int i = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                        this.crcFound = true;
                        if (i != this.crc.getValue()) {
                            throw new IOException("crc check failed in armored message.");
                        }
                        return this.read();
                    }
                    throw new IOException("no crc found in armored message.");
                }
                if (c == 45) {
                    while ((c = this.in.read()) >= 0 && c != 10 && c != 13) {
                    }
                    if (!this.crcFound) {
                        throw new IOException("crc check not found.");
                    }
                    this.crcFound = false;
                    this.start = true;
                    this.bufPtr = 3;
                    if (c < 0) {
                        this.isEndOfStream = true;
                    }
                    return -1;
                }
                this.bufPtr = this.decode(c, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else if (c >= 0) {
                this.bufPtr = this.decode(c, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else {
                this.isEndOfStream = true;
                return -1;
            }
        }
        c = this.outBuf[this.bufPtr++];
        this.crc.update(c);
        return c;
    }

    public void close() throws IOException {
        this.in.close();
    }

    static {
        int i;
        decodingTable = new byte[128];
        for (i = 65; i <= 90; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 48 + 52);
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }
}

