/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.util.encoders.Hex;

public class RFC6637KDFCalculator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode((String)"416E6F6E796D6F75732053656E64657220202020");
    private final PGPDigestCalculator digCalc;
    private final int keyAlgorithm;

    public RFC6637KDFCalculator(PGPDigestCalculator digCalc, int keyAlgorithm) {
        this.digCalc = digCalc;
        this.keyAlgorithm = keyAlgorithm;
    }

    public byte[] createKey(ASN1ObjectIdentifier curveOID, ECPoint s, byte[] recipientFingerPrint) throws PGPException {
        try {
            ByteArrayOutputStream pOut = new ByteArrayOutputStream();
            byte[] encOid = curveOID.getEncoded();
            pOut.write(encOid, 1, encOid.length - 1);
            pOut.write(18);
            pOut.write(3);
            pOut.write(1);
            pOut.write(this.digCalc.getAlgorithm());
            pOut.write(this.keyAlgorithm);
            pOut.write(ANONYMOUS_SENDER);
            pOut.write(recipientFingerPrint);
            return RFC6637KDFCalculator.KDF(this.digCalc, s, RFC6637KDFCalculator.getKeyLen(this.keyAlgorithm), pOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("Exception performing KDF: " + e.getMessage(), e);
        }
    }

    private static byte[] KDF(PGPDigestCalculator digCalc, ECPoint s, int keyLen, byte[] param) throws IOException {
        byte[] ZB = s.getXCoord().getEncoded();
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(0);
        dOut.write(0);
        dOut.write(0);
        dOut.write(1);
        dOut.write(ZB);
        dOut.write(param);
        byte[] digest = digCalc.getDigest();
        byte[] key = new byte[keyLen];
        System.arraycopy(digest, 0, key, 0, key.length);
        return key;
    }

    private static int getKeyLen(int algID) throws PGPException {
        switch (algID) {
            case 7: {
                return 16;
            }
            case 8: {
                return 24;
            }
            case 9: {
                return 32;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + algID);
    }
}

