/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.BufferedBlockCipher;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.bc.BcImplProvider;
import org.spongycastle.openpgp.operator.bc.BcUtil;
import org.spongycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
            BufferedBlockCipher cipher = BcUtil.createSymmetricKeyWrapper(true, engine, key, new byte[engine.getBlockSize()]);
            byte[] out = new byte[sessionInfo.length];
            int len = cipher.processBytes(sessionInfo, 0, sessionInfo.length, out, 0);
            len += cipher.doFinal(out, len);
            return out;
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("encryption failed: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

