/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.jcajce.util.NamedJcaJceHelper;
import org.spongycastle.jcajce.util.ProviderJcaJceHelper;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PGPDataEncryptor;
import org.spongycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.jcajce.OperatorHelper;
import org.spongycastle.openpgp.operator.jcajce.PGPUtil;
import org.spongycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;

    public JcePGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    byte[] iv = new byte[this.c.getBlockSize()];
                    this.c.init(1, (Key)PGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes), new IvParameterSpec(iv));
                } else {
                    this.c.init(1, PGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes));
                }
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key: " + e.getMessage(), e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new PGPException("imvalid algorithm parameter: " + e.getMessage(), e);
            }
        }

        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

