/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.cms.PasswordRecipientInfo;
import org.spongycastle.asn1.pkcs.PBKDF2Params;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.AuthAttributesProvider;
import org.spongycastle.cms.CMSAlgorithm;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSSecureReadable;
import org.spongycastle.cms.PasswordRecipient;
import org.spongycastle.cms.PasswordRecipientId;
import org.spongycastle.cms.Recipient;
import org.spongycastle.cms.RecipientInformation;
import org.spongycastle.cms.RecipientOperator;
import org.spongycastle.crypto.PBEParametersGenerator;
import org.spongycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.util.Integers;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            ASN1Encodable params;
            if (this.info.getKeyDerivationAlgorithm() != null && (params = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return params.toASN1Primitive().getEncoded();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.info.getKeyDerivationAlgorithm();
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        PasswordRecipient pbeRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance((Object)this.info.getKeyEncryptionAlgorithm());
        AlgorithmIdentifier kekAlgParams = AlgorithmIdentifier.getInstance((Object)kekAlg.getParameters());
        byte[] passwordBytes = this.getPasswordBytes(pbeRecipient.getPasswordConversionScheme(), pbeRecipient.getPassword());
        PBKDF2Params params = PBKDF2Params.getInstance((Object)this.info.getKeyDerivationAlgorithm().getParameters());
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwordBytes, params.getSalt(), params.getIterationCount().intValue());
        int keySize = (Integer)KEYSIZES.get(kekAlgParams.getAlgorithm());
        byte[] derivedKey = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        return pbeRecipient.getRecipientOperator(kekAlgParams, this.messageAlgorithm, derivedKey, this.info.getEncryptedKey().getOctets());
    }

    protected byte[] getPasswordBytes(int scheme, char[] password) {
        if (scheme == 0) {
            return PBEParametersGenerator.PKCS5PasswordToBytes((char[])password);
        }
        return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])password);
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf((int)8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf((int)16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf((int)16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf((int)16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, Integers.valueOf((int)192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, Integers.valueOf((int)128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, Integers.valueOf((int)192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, Integers.valueOf((int)256));
    }
}

