/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms.bc;

import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.PasswordRecipient;
import org.spongycastle.cms.bc.EnvelopedDataHelper;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.Wrapper;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;

public abstract class BcPasswordRecipient
implements PasswordRecipient {
    private int schemeID = 1;
    private char[] password;

    BcPasswordRecipient(char[] password) {
        this.password = password;
    }

    public BcPasswordRecipient setPasswordConversionScheme(int schemeID) {
        this.schemeID = schemeID;
        return this;
    }

    protected KeyParameter extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        Wrapper keyEncryptionCipher = EnvelopedDataHelper.createRFC3211Wrapper(keyEncryptionAlgorithm.getAlgorithm());
        keyEncryptionCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(derivedKey), ASN1OctetString.getInstance((Object)keyEncryptionAlgorithm.getParameters()).getOctets()));
        try {
            return new KeyParameter(keyEncryptionCipher.unwrap(encryptedContentEncryptionKey, 0, encryptedContentEncryptionKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new CMSException("unable to unwrap key: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public int getPasswordConversionScheme() {
        return this.schemeID;
    }

    public char[] getPassword() {
        return this.password;
    }
}

