/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openssl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.DERObjectIdentifier;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.nist.NISTObjectIdentifiers;
import org.spongycastle.asn1.pkcs.KeyDerivationFunc;
import org.spongycastle.asn1.pkcs.PBES2Parameters;
import org.spongycastle.asn1.pkcs.PBKDF2Params;
import org.spongycastle.asn1.pkcs.PKCS12PBEParams;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.jcajce.DefaultJcaJceHelper;
import org.spongycastle.jcajce.JcaJceHelper;
import org.spongycastle.jcajce.NamedJcaJceHelper;
import org.spongycastle.jcajce.ProviderJcaJceHelper;
import org.spongycastle.openssl.jcajce.PEMUtilities;
import org.spongycastle.operator.GenericKey;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.OutputEncryptor;
import org.spongycastle.operator.jcajce.JceGenericKey;

public class JceOpenSSLPKCS8EncryptorBuilder {
    public static final String AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId();
    public static final String PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4.getId();
    public static final String PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId();
    public static final String PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId();
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private AlgorithmParameters params;
    private ASN1ObjectIdentifier algOID;
    byte[] salt;
    int iterationCount;
    private Cipher cipher;
    private SecureRandom random;
    private AlgorithmParameterGenerator paramGen;
    private SecretKeyFactory secKeyFact;
    private char[] password;
    private SecretKey key;

    public JceOpenSSLPKCS8EncryptorBuilder(ASN1ObjectIdentifier algorithm) {
        this.algOID = algorithm;
        this.iterationCount = 2048;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setPasssword(char[] password) {
        this.password = password;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public OutputEncryptor build() throws OperatorCreationException {
        AlgorithmIdentifier algID;
        this.salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(this.salt);
        try {
            this.cipher = this.helper.createCipher(this.algOID.getId());
            if (PEMUtilities.isPKCS5Scheme2(this.algOID)) {
                this.paramGen = this.helper.createAlgorithmParameterGenerator(this.algOID.getId());
            } else {
                this.secKeyFact = this.helper.createSecretKeyFactory(this.algOID.getId());
            }
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException(this.algOID + " not available: " + e.getMessage(), e);
        }
        if (PEMUtilities.isPKCS5Scheme2(this.algOID)) {
            this.params = this.paramGen.generateParameters();
            try {
                KeyDerivationFunc scheme = new KeyDerivationFunc(this.algOID, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])this.params.getEncoded()));
                KeyDerivationFunc func = new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(this.salt, this.iterationCount));
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)func);
                v.add((ASN1Encodable)scheme);
                algID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)PBES2Parameters.getInstance((Object)new DERSequence(v)));
            }
            catch (IOException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
            this.key = PEMUtilities.generateSecretKeyForPKCS5Scheme2(this.algOID.getId(), this.password, this.salt, this.iterationCount);
            try {
                this.cipher.init(1, (Key)this.key, this.params);
            }
            catch (GeneralSecurityException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
        }
        if (PEMUtilities.isPKCS12((DERObjectIdentifier)this.algOID)) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new DEROctetString(this.salt));
            v.add((ASN1Encodable)new ASN1Integer((long)this.iterationCount));
            algID = new AlgorithmIdentifier(this.algOID, (ASN1Encodable)PKCS12PBEParams.getInstance((Object)new DERSequence(v)));
            try {
                PBEKeySpec pbeSpec = new PBEKeySpec(this.password);
                PBEParameterSpec defParams = new PBEParameterSpec(this.salt, this.iterationCount);
                this.key = this.secKeyFact.generateSecret(pbeSpec);
                this.cipher.init(1, (Key)this.key, defParams);
            }
            catch (GeneralSecurityException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
        } else {
            throw new OperatorCreationException("unknown algorithm: " + this.algOID, null);
        }
        return new OutputEncryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algID;
            }

            public OutputStream getOutputStream(OutputStream encOut) {
                return new CipherOutputStream(encOut, JceOpenSSLPKCS8EncryptorBuilder.this.cipher);
            }

            public GenericKey getKey() {
                return new JceGenericKey(algID, JceOpenSSLPKCS8EncryptorBuilder.this.key);
            }
        };
    }
}

