/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tsp;

import org.spongycastle.asn1.DERInteger;
import org.spongycastle.asn1.tsp.Accuracy;

public class GenTimeAccuracy {
    private Accuracy accuracy;

    public GenTimeAccuracy(Accuracy accuracy) {
        this.accuracy = accuracy;
    }

    public int getSeconds() {
        return this.getTimeComponent((DERInteger)this.accuracy.getSeconds());
    }

    public int getMillis() {
        return this.getTimeComponent((DERInteger)this.accuracy.getMillis());
    }

    public int getMicros() {
        return this.getTimeComponent((DERInteger)this.accuracy.getMicros());
    }

    private int getTimeComponent(DERInteger time) {
        if (time != null) {
            return time.getValue().intValue();
        }
        return 0;
    }

    public String toString() {
        return this.getSeconds() + "." + this.format(this.getMillis()) + this.format(this.getMicros());
    }

    private String format(int v) {
        if (v < 10) {
            return "00" + v;
        }
        if (v < 100) {
            return "0" + v;
        }
        return Integer.toString(v);
    }
}

