/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.cms.CompressedData;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSCompressedData;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.operator.OutputCompressor;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public CMSCompressedData generate(CMSTypedData content, OutputCompressor compressor) throws CMSException {
        BEROctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream zOut = compressor.getOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = compressor.getAlgorithmIdentifier();
            comOcts = new BEROctetString(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new CMSException("exception encoding data.", e);
        }
        ContentInfo comContent = new ContentInfo(content.getContentType(), (ASN1Encodable)comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, (ASN1Encodable)new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }
}

