/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.BERSequence;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedHelper;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.cms.SignerInformationVerifier;
import org.spongycastle.cms.SignerInformationVerifierProvider;
import org.spongycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.util.Store;

public class CMSSignedData {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData c) {
        this.signedData = c.signedData;
        this.contentInfo = c.contentInfo;
        this.signedContent = c.signedContent;
        this.signerInfoStore = c.signerInfoStore;
    }

    public CMSSignedData(byte[] sigBlock) throws CMSException {
        this(CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(Map hashes, byte[] sigBlock) throws CMSException {
        this(hashes, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, InputStream sigData) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(sigData)));
    }

    public CMSSignedData(InputStream sigData) throws CMSException {
        this(CMSUtils.readContentInfo(sigData));
    }

    public CMSSignedData(final CMSProcessable signedContent, ContentInfo sigData) throws CMSException {
        this.signedContent = signedContent instanceof CMSTypedData ? (CMSTypedData)signedContent : new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            public void write(OutputStream out) throws IOException, CMSException {
                signedContent.write(out);
            }

            public Object getContent() {
                return signedContent.getContent();
            }
        };
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(Map hashes, ContentInfo sigData) throws CMSException {
        this.hashes = hashes;
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo sigData) throws CMSException {
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance((Object)this.contentInfo.getContent());
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set s = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            DefaultSignatureAlgorithmIdentifierFinder sigAlgFinder = new DefaultSignatureAlgorithmIdentifierFinder();
            for (int i = 0; i != s.size(); ++i) {
                SignerInfo info = SignerInfo.getInstance((Object)s.getObjectAt(i));
                ASN1ObjectIdentifier contentType = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    signerInfos.add(new SignerInformation(info, contentType, this.signedContent, null));
                    continue;
                }
                Object obj = this.hashes.keySet().iterator().next();
                byte[] hash = obj instanceof String ? (byte[])this.hashes.get(info.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(info.getDigestAlgorithm().getAlgorithm());
                signerInfos.add(new SignerInformation(info, contentType, null, hash));
            }
            this.signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this.signerInfoStore;
    }

    public Store getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public Store getCRLs() {
        return HELPER.getCRLs(this.signedData.getCRLs());
    }

    public Store getAttributeCertificates() {
        return HELPER.getAttributeCertificates(this.signedData.getCertificates());
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat) {
        return HELPER.getOtherRevocationInfo(otherRevocationInfoFormat, this.signedData.getCRLs());
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider) throws CMSException {
        return this.verifySignatures(verifierProvider, false);
    }

    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider, boolean ignoreCounterSignatures) throws CMSException {
        Collection signers = this.getSignerInfos().getSigners();
        for (SignerInformation signer : signers) {
            try {
                SignerInformationVerifier verifier = verifierProvider.get(signer.getSID());
                if (!signer.verify(verifier)) {
                    return false;
                }
                if (ignoreCounterSignatures) continue;
                Collection counterSigners = signer.getCounterSignatures().getSigners();
                for (SignerInformation counterSigner : counterSigners) {
                    SignerInformationVerifier counterVerifier;
                    if (counterSigner.verify(counterVerifier = verifierProvider.get(signer.getSID()))) continue;
                    return false;
                }
            }
            catch (OperatorCreationException e) {
                throw new CMSException("failure in verifier provider: " + e.getMessage(), e);
            }
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData signedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.signerInfoStore = signerInformationStore;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            digestAlgs.add((ASN1Encodable)CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            vec.add((ASN1Encodable)signer.toASN1Structure());
        }
        DERSet digests = new DERSet(digestAlgs);
        DERSet signers = new DERSet(vec);
        ASN1Sequence sD = (ASN1Sequence)signedData.signedData.toASN1Primitive();
        vec = new ASN1EncodableVector();
        vec.add(sD.getObjectAt(0));
        vec.add((ASN1Encodable)digests);
        for (int i = 2; i != sD.size() - 1; ++i) {
            vec.add(sD.getObjectAt(i));
        }
        vec.add((ASN1Encodable)signers);
        cms.signedData = SignedData.getInstance((Object)new BERSequence(vec));
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), (ASN1Encodable)cms.signedData);
        return cms;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData signedData, Store certificates, Store attrCerts, Store revocations) throws CMSException {
        ASN1Set set;
        CMSSignedData cms = new CMSSignedData(signedData);
        ASN1Set certSet = null;
        ASN1Set crlSet = null;
        if (certificates != null || attrCerts != null) {
            ASN1Set set2;
            ArrayList certs = new ArrayList();
            if (certificates != null) {
                certs.addAll(CMSUtils.getCertificatesFromStore(certificates));
            }
            if (attrCerts != null) {
                certs.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((set2 = CMSUtils.createBerSetFromList(certs)).size() != 0) {
                certSet = set2;
            }
        }
        if (revocations != null && (set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(revocations))).size() != 0) {
            crlSet = set;
        }
        cms.signedData = new SignedData(signedData.signedData.getDigestAlgorithms(), signedData.signedData.getEncapContentInfo(), certSet, crlSet, signedData.signedData.getSignerInfos());
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), (ASN1Encodable)cms.signedData);
        return cms;
    }
}

