/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.cms.ecc.ECCCMSSharedInfo;
import org.spongycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.spongycastle.asn1.pkcs.PrivateKeyInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.asn1.x9.X9ObjectIdentifiers;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.KeyAgreeRecipient;
import org.spongycastle.cms.jcajce.CMSUtils;
import org.spongycastle.cms.jcajce.DefaultJcaJceExtHelper;
import org.spongycastle.cms.jcajce.EnvelopedDataHelper;
import org.spongycastle.cms.jcajce.KeyMaterialGenerator;
import org.spongycastle.cms.jcajce.NamedJcaJceExtHelper;
import org.spongycastle.cms.jcajce.ProviderJcaJceExtHelper;
import org.spongycastle.cms.jcajce.RFC5753KeyMaterialGenerator;
import org.spongycastle.jcajce.spec.MQVParameterSpec;
import org.spongycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.spongycastle.operator.DefaultSecretKeySizeProvider;
import org.spongycastle.operator.SecretKeySizeProvider;
import org.spongycastle.util.Pack;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private static final Set possibleOldMessages = new HashSet();
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    private SecretKeySizeProvider keySizeProvider;
    private static KeyMaterialGenerator old_ecc_cms_Generator;
    private static KeyMaterialGenerator ecc_cms_Generator;

    public JceKeyAgreeRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.keySizeProvider = new DefaultSecretKeySizeProvider();
        this.recipientKey = recipientKey;
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier keyEncAlg, ASN1ObjectIdentifier wrapAlg, PublicKey senderPublicKey, ASN1OctetString userKeyingMaterial, PrivateKey receiverPrivateKey, KeyMaterialGenerator kmGen) throws CMSException, GeneralSecurityException, IOException {
        if (CMSUtils.isMQV(keyEncAlg.getAlgorithm())) {
            byte[] ukmKeyingMaterial;
            MQVuserKeyingMaterial ukm = MQVuserKeyingMaterial.getInstance((Object)userKeyingMaterial.getOctets());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), ukm.getEphemeralPublicKey().getPublicKey().getBytes());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(keyEncAlg.getAlgorithm());
            PublicKey ephemeralKey = fact.generatePublic(pubSpec);
            KeyAgreement agreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
            byte[] byArray = ukmKeyingMaterial = ukm.getAddedukm() != null ? ukm.getAddedukm().getOctets() : null;
            if (kmGen == old_ecc_cms_Generator) {
                ukmKeyingMaterial = old_ecc_cms_Generator.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), ukmKeyingMaterial);
            }
            agreement.init((Key)receiverPrivateKey, (AlgorithmParameterSpec)new MQVParameterSpec(receiverPrivateKey, ephemeralKey, ukmKeyingMaterial));
            agreement.doPhase(senderPublicKey, true);
            return agreement.generateSecret(wrapAlg.getId());
        }
        KeyAgreement agreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
        UserKeyingMaterialSpec userKeyingMaterialSpec = null;
        if (userKeyingMaterial != null) {
            byte[] ukmKeyingMaterial = kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), userKeyingMaterial.getOctets());
            userKeyingMaterialSpec = new UserKeyingMaterialSpec(ukmKeyingMaterial);
        } else {
            byte[] ukmKeyingMaterial = kmGen.generateKDFMaterial(wrapAlg, this.keySizeProvider.getKeySize(wrapAlg), null);
            userKeyingMaterialSpec = new UserKeyingMaterialSpec(ukmKeyingMaterial);
        }
        agreement.init((Key)receiverPrivateKey, (AlgorithmParameterSpec)userKeyingMaterialSpec);
        agreement.doPhase(senderPublicKey, true);
        return agreement.generateSecret(wrapAlg.getId());
    }

    private Key unwrapSessionKey(ASN1ObjectIdentifier wrapAlg, SecretKey agreedKey, ASN1ObjectIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher keyCipher = this.helper.createCipher(wrapAlg);
        keyCipher.init(4, agreedKey);
        return keyCipher.unwrap(encryptedContentEncryptionKey, this.helper.getBaseCipherName(contentEncryptionAlgorithm), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, SubjectPublicKeyInfo senderKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            ASN1ObjectIdentifier wrapAlg = AlgorithmIdentifier.getInstance((Object)keyEncryptionAlgorithm.getParameters()).getAlgorithm();
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(senderKey.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(keyEncryptionAlgorithm.getAlgorithm());
            PublicKey senderPublicKey = fact.generatePublic(pubSpec);
            try {
                SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey, ecc_cms_Generator);
                return this.unwrapSessionKey(wrapAlg, agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
            }
            catch (InvalidKeyException e) {
                if (possibleOldMessages.contains(keyEncryptionAlgorithm.getAlgorithm())) {
                    SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey, old_ecc_cms_Generator);
                    return this.unwrapSessionKey(wrapAlg, agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
                }
                throw e;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException("originator key spec invalid.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (Exception e) {
            throw new CMSException("originator key invalid.", e);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        return PrivateKeyInfo.getInstance((Object)this.recipientKey.getEncoded()).getPrivateKeyAlgorithm();
    }

    static {
        possibleOldMessages.add(X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme);
        possibleOldMessages.add(X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme);
        old_ecc_cms_Generator = new KeyMaterialGenerator(){

            public byte[] generateKDFMaterial(ASN1ObjectIdentifier keyAlgorithm, int keySize, byte[] userKeyMaterialParameters) {
                ECCCMSSharedInfo eccInfo = new ECCCMSSharedInfo(new AlgorithmIdentifier(keyAlgorithm, (ASN1Encodable)DERNull.INSTANCE), userKeyMaterialParameters, Pack.intToBigEndian((int)keySize));
                try {
                    return eccInfo.getEncoded("DER");
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to create KDF material: " + e);
                }
            }
        };
        ecc_cms_Generator = new RFC5753KeyMaterialGenerator();
    }
}

