/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms.jcajce;

import java.io.IOException;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.cms.ecc.ECCCMSSharedInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.jcajce.CMSUtils;
import org.spongycastle.cms.jcajce.KeyMaterialGenerator;
import org.spongycastle.util.Pack;

class RFC5753KeyMaterialGenerator
implements KeyMaterialGenerator {
    RFC5753KeyMaterialGenerator() {
    }

    public byte[] generateKDFMaterial(ASN1ObjectIdentifier keyAlgorithm, int keySize, byte[] userKeyMaterialParameters) {
        ECCCMSSharedInfo eccInfo = CMSUtils.isDES(keyAlgorithm.getId()) || keyAlgorithm.equals((Object)PKCSObjectIdentifiers.id_alg_CMSRC2wrap) ? new ECCCMSSharedInfo(new AlgorithmIdentifier(keyAlgorithm, (ASN1Encodable)DERNull.INSTANCE), userKeyMaterialParameters, Pack.intToBigEndian((int)keySize)) : new ECCCMSSharedInfo(new AlgorithmIdentifier(keyAlgorithm), userKeyMaterialParameters, Pack.intToBigEndian((int)keySize));
        try {
            return eccInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create KDF material: " + e);
        }
    }
}

