/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.dvcs;

import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.dvcs.DVCSObjectIdentifiers;
import org.spongycastle.asn1.dvcs.ServiceType;
import org.spongycastle.asn1.x509.GeneralName;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.dvcs.CCPDRequestData;
import org.spongycastle.dvcs.CPDRequestData;
import org.spongycastle.dvcs.DVCSConstructionException;
import org.spongycastle.dvcs.DVCSMessage;
import org.spongycastle.dvcs.DVCSRequestData;
import org.spongycastle.dvcs.DVCSRequestInfo;
import org.spongycastle.dvcs.VPKCRequestData;
import org.spongycastle.dvcs.VSDRequestData;

public class DVCSRequest
extends DVCSMessage {
    private org.spongycastle.asn1.dvcs.DVCSRequest asn1;
    private DVCSRequestInfo reqInfo;
    private DVCSRequestData data;

    public DVCSRequest(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance((Object)signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSRequest(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSRequestData.equals((Object)contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? org.spongycastle.asn1.dvcs.DVCSRequest.getInstance((Object)contentInfo.getContent()) : org.spongycastle.asn1.dvcs.DVCSRequest.getInstance((Object)ASN1OctetString.getInstance((Object)contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
        this.reqInfo = new DVCSRequestInfo(this.asn1.getRequestInformation());
        int service = this.reqInfo.getServiceType();
        if (service == ServiceType.CPD.getValue().intValue()) {
            this.data = new CPDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VSD.getValue().intValue()) {
            this.data = new VSDRequestData(this.asn1.getData());
        } else if (service == ServiceType.VPKC.getValue().intValue()) {
            this.data = new VPKCRequestData(this.asn1.getData());
        } else if (service == ServiceType.CCPD.getValue().intValue()) {
            this.data = new CCPDRequestData(this.asn1.getData());
        } else {
            throw new DVCSConstructionException("Unknown service type: " + service);
        }
    }

    public ASN1Encodable getContent() {
        return this.asn1;
    }

    public DVCSRequestInfo getRequestInfo() {
        return this.reqInfo;
    }

    public DVCSRequestData getData() {
        return this.data;
    }

    public GeneralName getTransactionIdentifier() {
        return this.asn1.getTransactionIdentifier();
    }
}

