/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jcajce.provider.asymmetric.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DSA;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.NullDigest;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.signers.DSAKCalculator;
import org.spongycastle.crypto.signers.ECDSASigner;
import org.spongycastle.crypto.signers.ECNRSigner;
import org.spongycastle.crypto.signers.HMacDSAKCalculator;
import org.spongycastle.jcajce.provider.asymmetric.util.DSABase;
import org.spongycastle.jcajce.provider.asymmetric.util.DSAEncoder;
import org.spongycastle.jcajce.provider.asymmetric.util.ECUtil;

public class SignatureSpi
extends DSABase {
    SignatureSpi(Digest digest, DSA signer, DSAEncoder encoder) {
        super(digest, signer, encoder);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePublicKeyParameter(publicKey);
        this.digest.reset();
        this.signer.init(false, (CipherParameters)param);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (this.appRandom != null) {
            this.signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)param, this.appRandom));
        } else {
            this.signer.init(true, (CipherParameters)param);
        }
    }

    private static class CVCDSAEncoder
    implements DSAEncoder {
        private CVCDSAEncoder() {
        }

        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            byte[] second;
            byte[] first = this.makeUnsigned(r);
            byte[] res = first.length > (second = this.makeUnsigned(s)).length ? new byte[first.length * 2] : new byte[second.length * 2];
            System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
            System.arraycopy(second, 0, res, res.length - second.length, second.length);
            return res;
        }

        private byte[] makeUnsigned(BigInteger val) {
            byte[] res = val.toByteArray();
            if (res[0] == 0) {
                byte[] tmp = new byte[res.length - 1];
                System.arraycopy(res, 1, tmp, 0, tmp.length);
                return tmp;
            }
            return res;
        }

        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            byte[] first = new byte[encoding.length / 2];
            byte[] second = new byte[encoding.length / 2];
            System.arraycopy(encoding, 0, first, 0, first.length);
            System.arraycopy(encoding, first.length, second, 0, second.length);
            sig[0] = new BigInteger(1, first);
            sig[1] = new BigInteger(1, second);
            return sig;
        }
    }

    private static class StdDSAEncoder
    implements DSAEncoder {
        private StdDSAEncoder() {
        }

        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(r));
            v.add((ASN1Encodable)new ASN1Integer(s));
            return new DERSequence(v).getEncoded("DER");
        }

        public BigInteger[] decode(byte[] encoding) throws IOException {
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])encoding);
            BigInteger[] sig = new BigInteger[]{ASN1Integer.getInstance((Object)s.getObjectAt(0)).getValue(), ASN1Integer.getInstance((Object)s.getObjectAt(1)).getValue()};
            return sig;
        }
    }

    public static class ecCVCDSA512
    extends SignatureSpi {
        public ecCVCDSA512() {
            super((Digest)new SHA512Digest(), (DSA)new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA384
    extends SignatureSpi {
        public ecCVCDSA384() {
            super((Digest)new SHA384Digest(), (DSA)new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA256
    extends SignatureSpi {
        public ecCVCDSA256() {
            super((Digest)new SHA256Digest(), (DSA)new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA224
    extends SignatureSpi {
        public ecCVCDSA224() {
            super((Digest)new SHA224Digest(), (DSA)new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA
    extends SignatureSpi {
        public ecCVCDSA() {
            super((Digest)new SHA1Digest(), (DSA)new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecNR512
    extends SignatureSpi {
        public ecNR512() {
            super((Digest)new SHA512Digest(), (DSA)new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR384
    extends SignatureSpi {
        public ecNR384() {
            super((Digest)new SHA384Digest(), (DSA)new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR256
    extends SignatureSpi {
        public ecNR256() {
            super((Digest)new SHA256Digest(), (DSA)new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR224
    extends SignatureSpi {
        public ecNR224() {
            super((Digest)new SHA224Digest(), (DSA)new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR
    extends SignatureSpi {
        public ecNR() {
            super((Digest)new SHA1Digest(), (DSA)new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSARipeMD160
    extends SignatureSpi {
        public ecDSARipeMD160() {
            super((Digest)new RIPEMD160Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA512
    extends SignatureSpi {
        public ecDetDSA512() {
            super((Digest)new SHA512Digest(), (DSA)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA512Digest())), new StdDSAEncoder());
        }
    }

    public static class ecDSA512
    extends SignatureSpi {
        public ecDSA512() {
            super((Digest)new SHA512Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA384
    extends SignatureSpi {
        public ecDetDSA384() {
            super((Digest)new SHA384Digest(), (DSA)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA384Digest())), new StdDSAEncoder());
        }
    }

    public static class ecDSA384
    extends SignatureSpi {
        public ecDSA384() {
            super((Digest)new SHA384Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA256
    extends SignatureSpi {
        public ecDetDSA256() {
            super((Digest)new SHA256Digest(), (DSA)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest())), new StdDSAEncoder());
        }
    }

    public static class ecDSA256
    extends SignatureSpi {
        public ecDSA256() {
            super((Digest)new SHA256Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA224
    extends SignatureSpi {
        public ecDetDSA224() {
            super((Digest)new SHA224Digest(), (DSA)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA224Digest())), new StdDSAEncoder());
        }
    }

    public static class ecDSA224
    extends SignatureSpi {
        public ecDSA224() {
            super((Digest)new SHA224Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSAnone
    extends SignatureSpi {
        public ecDSAnone() {
            super((Digest)new NullDigest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDetDSA
    extends SignatureSpi {
        public ecDetDSA() {
            super((Digest)new SHA1Digest(), (DSA)new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA1Digest())), new StdDSAEncoder());
        }
    }

    public static class ecDSA
    extends SignatureSpi {
        public ecDSA() {
            super((Digest)new SHA1Digest(), (DSA)new ECDSASigner(), new StdDSAEncoder());
        }
    }
}

