/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.ocsp;

import java.text.ParseException;
import java.util.Date;
import org.spongycastle.asn1.ASN1GeneralizedTime;
import org.spongycastle.asn1.ocsp.RevokedInfo;
import org.spongycastle.asn1.x509.CRLReason;
import org.spongycastle.ocsp.CertificateStatus;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public RevokedStatus(Date revocationDate, int reason) {
        this.info = new RevokedInfo(new ASN1GeneralizedTime(revocationDate), CRLReason.lookup((int)reason));
    }

    public Date getRevocationTime() {
        try {
            return this.info.getRevocationTime().getDate();
        }
        catch (ParseException e) {
            throw new IllegalStateException("ParseException:" + e.getMessage());
        }
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

